@extends('master')

@section('title')
Password Reset
@stop
@section('styles')
<link rel="stylesheet" href="{{ asset('css/style.css') }}">
@stop

@section('content')
<div class="header" id="home">
	<div class="container">
		<ul style="margin-bottom: 0.25rem;">
            <li><i class="fa fa-phone" aria-hidden="true"></i> Call: (011) 022 0642</li>
            <li><i class="fa fa-envelope-o" aria-hidden="true"></i> <a href="mailto:info@prestigecredit.co.za">info@prestigecredit.co.za</a></li>
            <li><a href="terms-and-conditions"><i class="fa fa-file-o" aria-hidden="true"></i> Terms & Conditions of use</a></li>
        </ul>
	</div>
</div>
<img style="max-width: 20%;display: block; margin-top: 2rem; margin-left: auto; margin-right: auto;" src="/img/PrestigeAdvantage.jpg" />
<hr>
    @if(Session::has('status'))
        <div data-alert class="alert-box info">
          {{ Session::get('status') }}
          <a href="#" class="close">&times;</a>
        </div>
    @endif

    @if(Session::has('error'))
        <div data-alert class="alert-box alert">
          {{ Session::get('error') }}
          <a href="#" class="close">&times;</a>
        </div>
    @endif

    <div class="row">
        <div class="large-12 columns">
            <h1>Password Reset</h1>
        </div>
    </div>

        <div class="row">
            <div class="large-12 columns">
                {{ Form::open() }}
                    {{ Form::hidden('token', $token) }}
                    <div class="row">
                        <div class="large-12 columns">
                            <label for="email">Email Address <small>{{ $errors->first('email') }}</small></label>
                            {{ Form::text('email', null, ['id' => 'email']) }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="large-6 columns">
                            <label for="password">Password <small>{{ $errors->first('password') }}</small></label>
                            {{ Form::password('password', null, ['id' => 'password']) }}
                        </div>
                        <div class="large-6 columns">
                            <label for="confirm">Password Confirmation</label>
                            {{ Form::password('password_confirmation', null, ['id' => 'confirm']) }}
                        </div>
                    </div>
                    <div class="row">
                        <div class="large-3 columns">
                            {{ Form::submit('Submit', ['class' => 'button tiny radius wideButton']) }}
                        </div>
                    </div>
                {{ Form::close() }}
            </div>
        </div>

@include('partials.footer')
@stop