@extends('master')

@section('title')
    Edit User
@stop

@section('styles')
<style>

.dropdown {
  position: relative;
  font-size: 14px;
  color: #333;
  z-index:1;
}
.dropdown .dropdown-list {
  padding: 12px;
  background: #fff;
  position: absolute !important;
  position: initial;
  top: 30px;
  left: 2px;
  right: 2px;
  box-shadow: 0 1px 2px 1px rgba(0, 0, 0, 0.15);
  transform-origin: 50% 0;
  transform: scale(1, 0);
  transition: transform .15s ease-in-out .15s;
  max-height: 66vh;
  overflow-y: scroll;
}
.dropdown .dropdown-option {
  display: block;
  padding: 8px 12px;
  opacity: 0;
  transition: opacity .15s ease-in-out;
}
.dropdown .dropdown-label {
  display: block;
  height: 30px;
  background: #fff;
  border: 1px solid #ccc;
  padding: 6px 12px;
  line-height: 1;
  cursor: pointer;
}
.dropdown .dropdown-label:before {
  content: '▼';
  float: right;
}
.dropdown.on .dropdown-list {
  transform: scale(1, 1);
  transition-delay: 0s;
}
.dropdown.on .dropdown-list .dropdown-option {
  opacity: 1;
  transition-delay: .2s;
}
.dropdown.on .dropdown-label:before {
  content: '▲';
}
.dropdown [type="checkbox"] {
  position: relative;
  top: -1px;
  margin-right: 4px;
}

</style>
@stop

@section('content')

@include('partials.dashboard-menu')

	<h1>Edit user</h1>

 {{ Form::model($user, array('route' => ['users.edit-user', $user->id], 'files' => true)) }}
    <div class="row">
         <div class="col-md-6">
            <label><i class="fa fa-user" aria-hidden="true"></i>Full Name <small class="red">{{ $errors->first('name') }}</small></label>
             {{ Form::text('name') }}
         </div>
         <div class="col-md-6">
            <label><i class="fa fa-envelope" aria-hidden="true"></i> Email <small class="red">{{ $errors->first('email') }}</small></label>
            {{ Form::email('email') }}
         </div>
    </div>

    <div class="row">
        <div class="large-6 columns">
            <label>Designation <small class="red">{{ $errors->first('designation') }}</small></label>
            {{ Form::text('designation') }}
         </div>
        <div class="large-6 columns">
            <label> Link user to other Companies <em>(if application)</em> <small class="red">{{ $errors->first('companies') }}</small></label>
                <div class="dropdown" data-control="checkbox-dropdown">
                  <label class="dropdown-label">Select</label>
                  <div class="dropdown-list">
                    <a href="#" data-toggle="check-all" class="dropdown-option">
                      Check All
                    </a>
                    @foreach($companies as $company)
                    <label class="dropdown-option">
                      <input type="checkbox" name="companies[]" value="{{ $company->companyName }}" />
                      {{ $company->companyName }}
                    </label>
                     @endforeach
                  </div>
                </div>
        </div>
    </div>
    <hr>
    <div class="row">
        <h4 style="text-align:center;">Reset Password - <em>(if applicable)</em></h4>
        <div class="row">
            <div class="large-6 columns">
            <label><i class="fa fa-lock" aria-hidden="true"></i> New Password <small class="red">{{ $errors->first('password') }}</small></label>
            {{ Form::password('password') }}
            </div>
          <div class="large-6 columns">
            <label><i class="fa fa-lock" aria-hidden="true"></i> Confirm Password <small class="red">{{ $errors->first('password1') }}</small></label>
            {{ Form::password('password1') }}
          </div>
        </div>
    </div>
    <button style="display:block;margin-left: auto;margin-right:auto;" class="myButton" type="submit">Update Details</button>
{{ Form::close() }}
<hr>
@include('partials.footer')
@stop

@section('scripts')
<script src="{{ asset('/js/dropdown.js') }}"></script>
@stop





