@extends('master')

@section('title')
    Manage Companies
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.dashboard-menu')
@if(Session::has('view-search-error'))
    <div data-alert class="alert-box alert">
        {{ Session::get('view-search-error') }}
        <a href="#" class="close">&times;</a>
    </div>
@endif
<!-- success message -->
@if(Session::has('view-success'))
    <div data-alert class="alert-box">
        {{ Session::get('view-success') }}
        <a href="#" class="close">&times;</a>
    </div>
@endif

<h1>Companies Search Results</h1>
<!--<a class="myButton" style="width:12% ;text-align: center;" href="/new-company">Add New Company</a>-->
<a href="/new-company"><button class="myButton">Add New Company</button></a>

<div class="row">
<p style="text-align:center;">Enter company name then click enter</p>
    <form action="/company-search" method="GET" style="margin-bottom: -1rem !important;">
        <input style="width:50%;font-family: 'Lato', sans-serif;margin-left: auto;margin-right: auto;display: block;border-radius: 13px;" placeholder="Company Search..." type="text" value="" name="search" id="search">
    </form>
</div>
@if(isset($companies))
<table class="comapanyTable">
    <thead>
        <tr>
            <th width="10%">Companies</th>
            <th width="10%">Usage Log</th>
            <th width="10%">Edit Profile</th>
            <th width="10%">View Users</th>
            <th width="10%">Export Usage Log to exel</th>
        </tr>
    </thead>
    <tbody>
        @foreach($companies as $company)
            <tr>
                <td><a href="view-company/{{ $company->companyName }}">{{ $company->companyName }}</a></td>
                <td><a href="view-company-usage-log/{{ $company->companyName }}"><i class="fa fa-line-chart"></i></a></td>
                <td><a href="edit-company/{{ $company->id }}"> <i class="lightGrey fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                <td><a href="view-users/{{ $company->companyName }}"> <i class="fa fa-search" aria-hidden="true"></i></a></td>
                <td><a href="export-to-xml/{{ $company->companyName }}"> <i class="fa fa-file-excel-o"></i></a></td>
                </tr>
        @endforeach
    </tbody>
</table>
@else
    <h2>No result found.</h2>
@endif

@include('partials.footer')
@stop

@section('scripts')
<script>

</script>
@stop