@extends('master')

@section('title')
My Information
@stop

@section('content')

<div class="row">
    <div class="large-12 columns contentBg">

        <hr>
        <div class="row">
            <div class="large-3 columns">
                @include('partials.nav')
            </div>
            <div class="large-9 columns">

                <h4>Change Password</h4>
                {{ Form::model($user, ['route' => ['user.change-password', $user->id]]) }}

                <div class="row">
                    <div class="large-4 columns">
                        <label>
                            Password
                            <br /><small class="red">{{ $errors->first('password') }}</small>
                        </label>
                        {{ Form::password('password') }}
                    </div>
                </div>
                <div class="row">
                    <div class="large-4 columns">
                        <label>Password Again <br /><small class="red">{{ $errors->first('_new_password') }}</small></label>
                        {{ Form::password('new_password') }}
                    </div>
                </div>

                <div class="row">
                    <div class="large-3 large-centered text-center columns">
                        {{ Form::hidden('user', $user->id) }}
                        {{ Form::submit('Save', ['class' => 'button wideButton tiny radius']) }}
                    </div>
                </div>

                {{ Form::close() }}
            </div>
        </div>
    </div>
</div>

@stop

@section('scripts')

@stop

