@extends('master')

@section('title')
    All Users
@stop

@section('styles')

@stop

@section('content')

@include('partials.dashboard-menu')
<h1>Manage Users</h1>
<!--<a class="myButton" style="width:12% ;text-align: center;" href="/add-new-user">Add New User</a> -->
<a href="/add-new-user"><button class="myButton">Add New User</button></a>
<hr>
<div class="row">
<p style="text-align:center;">To search for user, type user name or email or company then click enter</p>
    <form action="/user-search" method="GET" style="margin-bottom: -1rem !important;">
        <input class="adminSearch" style="width:50%;font-family: 'Lato', sans-serif;margin-left: auto;margin-right: auto;display: block;border-radius: 13px;" placeholder="User Search..." type="text" value="" name="search" id="search">
    </form>
</div>

            <table class="comapanyTable">
                <thead>
                    <tr>
                        <th width="10%">User Name</th>
                        <th width="10%">Email</th>
                        <th width="10%">Edit</th>
                        <th width="10%">Link multiple companies</th>
                        <th width="10%">Delete</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td>{{ $user->email }}</td>
                            <td><a href="/edit-user/{{ $user->id }}"> <i class="lightGrey fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                            <td><a href="/link-user/{{ $user->id }}"> <i class="lightGrey fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                            <td><a onclick="return Conform_Delete()" href="/deleteUser/{{ $user->id }}"> <i class="fa fa-times" aria-hidden="true"></i></a></td>
                        </tr>
                    @endforeach
                </tbody>
            </table>

<hr>
@include('partials.footer')
@stop

@section('scripts')
    <script src="{{ asset('js/scripts.js') }}"></script>
    <script>
        function Conform_Delete()
        {
           return confirm("Are You Sure Want to Delete this user?");
        }
    </script>
@stop