@extends('master')

@section('title')
     Bank Code Report
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<h1>Principal Bank Code (24 Hour Delivery)</h1>
<p>A direct enquiry at the corresponding bank, allowing us to understand the strength of the applicants banking account and cash flow based on set amounts (usually double the amount the application is made for i.e. 50,000 credit would justify 100,000 bank code. This way you know you are safe.
   Standard Bank Code (24 hour bank code)</p>
<hr style="margin-top: 10px;">

<form id="mainForm" method="POST" action="/principal-bank-code" accept-charset="UTF-8" enctype="multipart/form-data">

<div class="row">
    <div class="large-6 columns">
        <label>Surname <small class="red">{{ $errors->first('surname') }}</small></label>
        {{ Form::text('surname')}}
    </div>
    <div class="large-6 columns">
        <label>Forename1 <small class="red">{{ $errors->first('forename1') }}</small></label>
        {{ Form::text('forename1') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Forename2 <small class="red">{{ $errors->first('forename2') }}</small></label>
        {{ Form::text('forename2')}}
    </div>
    <div class="large-6 columns">
        <label>Forename3 <small class="red">{{ $errors->first('forename3') }}</small></label>
        {{ Form::text('forename3') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Account Holder <small class="red">{{ $errors->first('accountHolder') }}</small></label>
        {{ Form::text('accountHolder') }}
    </div>
    <div class="large-6 columns">
        <label>ID Number <small class="red">{{ $errors->first('idNumber') }}</small></label>
        {{ Form::text('idNumber') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Bank <small class="red">{{ $errors->first('bank') }}</small></label>
        {{ Form::select('bank', [
             '' => 'Please Select',
             'ASBA' => 'ASBA',
             'NEDBANK' => 'NEDBANK',
             'STANDARD' => 'STANDARD BANK',
             'FNB' => 'FNB',
             'MERCANTILE' => 'MERCANTILE',
             'BANK OF ATHENS' => 'BANK OF ATHENS',
             'CITI BANK' => 'CITI BANK',
             'HSBC' => 'HSBC',
             'HBZ' => 'HBZ',
             'HABIB BANK' => 'HABIB BANK',
             'INVESTEC' => 'INVESTEC']
                                            ) }}
    </div>
    <div class="large-6 columns">
        <label>Country <small class="red">{{ $errors->first('country') }}</small></label>
        <select id="country" name="country" >
            <option value ="ZAF" >South Africa</option>
            <option value ="BWA" >Botswana</option>
            <option value ="LSO" >Lesotho</option>
            <option value ="MWI" >Malawi</option>
            <option value ="NAM" >Namibia</option>
            <option value ="SWZ" >Swaziland</option>
            <option value ="ZWE" >Zimbabwe</option>
        </select>
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Branch Name <small class="red">{{ $errors->first('branchName') }}</small></label>
        {{ Form::text('branchName') }}
    </div>
    <div class="large-6 columns">
        <label>Branch Code <small class="red">{{ $errors->first('branchCode') }}</small></label>
        {{ Form::text('branchCode')}}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Account Number <small class="red">{{ $errors->first('accountNumber') }}</small></label>
        {{ Form::text('accountNumber')}}
    </div>
    <div class="large-6 columns">
        <label>Account Type <small class="red">{{ $errors->first('accountType') }}</small></label>
        <select id="accountType" name="accountType" >
            <option value ="CUR" >Savings</option>
            <option value ="CUR" >Check</option>
            <option value ="CUR" >Transmission</option>
            <option value ="BON" >Bond</option>
            <option value ="SUB" >Subscription Share acc</option>
        </select>
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Amount <small class="red">{{ $errors->first('amount') }}</small></label>
        {{ Form::text('amount')}}
    </div>
    <div class="large-6 columns">
        <label>Terms <small class="red">{{ $errors->first('terms') }}</small></label>
        <select id="terms" name="terms" >
            <option value ="30" >30 Days</option>
            <option value ="60" >60 Days</option>
            <option value ="90" >90 Days</option>
            <option value ="120" >120 Days</option>
            <option value ="COD" >Cash On Delivery</option>
            <option value ="12" >12 Months</option>
            <option value ="24" >24 Months</option>
            <option value ="36" >36 Months</option>
        </select>
    </div>
</div>

<h4 style="text-align: center;">Select Supplier</h4>
      <div class="row cc-selector">
        <div class="large-6 columns">
                 <input id="compuscan" type="radio" name="response" value="Compuscan">
                 <label class="drinkcard-cc compuscan" for="compuscan"></label>
                 <h4>R{{$compuscanBankCodePrincipal}}</h4>
                 <input id="priceTag" style="display:none;" value="R{{$compuscanBankCodePrincipal}}">
        </div>
        <div class="large-6 columns">
                <input id="transunion" type="radio" name="response" value="Transunion">
                <label class="drinkcard-cc transunion" for="transunion"></label>
                <h4>R{{$transunionBankCodePrincipal}}</h4>
                <input id="priceTag2" style="display:none;" value="R{{$transunionBankCodePrincipal}}">
        </div>
      </div>

<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> <span id="response"></span></p>
		    <p><strong>Report type: </strong> Commercial Bank Code Report</p>
		    <p><strong>Turnaround Time: </strong> 24 hours</p>
		    <p><strong>Amount Ex VAT: </strong> <span id="price"></span></p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm Order</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>

</form>
<hr>
@include('partials.footer')
<script>
    $('#submitBtn').click(function() {
    if(document.getElementById('compuscan').checked) {
     $('#response').text($('#compuscan').val());
     $('#price').text($('#priceTag').val());
     //document.getElementById('providor')=='Compuscan';
    }else if(document.getElementById('transunion').checked) {
      $('#response').text($('#transunion').val());
      $('#price').text($('#priceTag2').val());
      //document.getElementById('providor')=='Transunion';
    }
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
@stop