@extends('master')

@section('title')
    On-File Report
@stop

@section('styles')

@stop

@section('content')

@include('partials.nav')

<h1>On File Report</h1>

<p>This is an on-file report received that reflects the following BASIC information to help understand who your customer is at a lower level. Business CIPC, Business Adverse, Principal Adverse, Principal Links and Affiliations, Enquiry history and on file data where applicable This report is designed for larger COD purchases or small accounts of up to R50,000,00. This report will help to understand who you are dealing with and a small understanding of their business.</p>

<hr style="margin-top: 10px;">

<form id="mainForm" method="POST" action="/on-file-commercial" accept-charset="UTF-8" enctype="multipart/form-data">

<div class="row">
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('businessName'))
        <label class="red">Business name *</label>
        {{ Form::text('businessName', ['id' => 'businessName','class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
    @else
        <label>Business name *<small class="red">{{ $errors->first('businessName') }}</small></label>
        <input type="text" id="businessName" name="businessName" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>

    @endif
    </div>
    <div class="large-6 columns">
     <!-- required -->
        @if($errors->first('regNumber'))
            <label class="red">Registration Number *</label>
            {{ Form::text('regNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Registration Number *</label>
            <input type="text" id="regNumber" name="regNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>
<hr>

<h4 style="text-align: center;">Select Supplier</h4>
      <div class="row cc-selector">
        <div class="large-4 columns">
                 <input id="compuscan" type="radio" name="response" value="Compuscan">
                 <label class="drinkcard-cc compuscan" for="compuscan">
                 <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">Price: R{{$compuscanOnfile}}</p>
                 </label>

                 <input id="priceTag" style="display:none;" value="R{{$compuscanOnfile}}">
        </div>
        <div class="large-4 columns">
                <input id="transunion" type="radio" name="response" value="Transunion">
                <label class="drinkcard-cc transunion" for="transunion">
                <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">Price: R{{$transunion}}</p>
                </label>

                <input id="priceTag2" style="display:none;" value="R{{$transunion}}">
        </div>
          <div class="large-4 columns">
              <input id="xds" type="radio" name="response" value="xds">
              <label class="drinkcard-cc xds" for="xds">
                  <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">Price: R{{$xdsOnfile}}</p>
              </label>

              <input id="priceTag3" style="display:none;" value="R{{$xdsOnfile}}">
          </div>
      </div>

<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> <span id="response"></span></p>
		    <p><strong>Report type: </strong> Commercial On File Report</p>
		    <p><strong>Turnaround Time: </strong> Instant</p>
		    <p><strong>Amount Ex VAT: </strong> <span id="price"></span></p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm Order</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>
</form>
<hr>
@include('partials.footer')

@stop

@section('scripts')
<script src={{ asset('https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js') }}></script>
<script>
checkFormsValidity = function(){
var myforms = document.forms["mainForm"];
    if(myforms.checkValidity()) {
        sbmtBtn.disabled = false;
    } else {
        sbmtBtn.disabled = true;
    }
}
</script>
<script>
    $('#submitBtn').click(function() {
    if(document.getElementById('compuscan').checked) {
     $('#response').text($('#compuscan').val());
     $('#price').text($('#priceTag').val());
     //document.getElementById('providor')=='Compuscan';
    }else if(document.getElementById('transunion').checked) {
      $('#response').text($('#transunion').val());
      $('#price').text($('#priceTag2').val());
    }
    else if(document.getElementById('xds').checked) {
        $('#response').text($('#xds').val());
        $('#price').text($('#priceTag3').val());
    }
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable
    this.disabled = true;
}
</script>
@stop






