@extends('master')

@section('title')
    Manage Users
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.dashboard-menu')

<h1>Companies</h1>
<a class="myButton" style="width:12% ;text-align: center;" href="/new-company">Add New Company</a>

<div class="row">
<p style="text-align:center;">Enter company name then press enter</p>
    <form action="/company-search" method="GET" style="margin-bottom: -1rem !important;">
        <input style="width:50%;font-family: 'Lato', sans-serif;margin-left: auto;margin-right: auto;display: block;" placeholder="Company Search..." type="text" value="" name="search" id="search">
    </form>
</div>

<table class="comapanyTable">
    <thead>
        <tr>
            <th width="10%">Companies</th>
            <th width="10%">View Company Info</th>
            <th width="10%">Usage Log</th>
            <th width="10%">Edit Profile</th>
            <th width="10%">View Users</th>
            <th width="10%">Export Usage Log to exel</th>
        </tr>
    </thead>
    <tbody>
        @foreach($companies as $company)
            <tr>
                <td>{{ $company->companyName }}</td>
                <td><a href="/view-company/{{ $company->companyName }}"> <i class="fa fa-eye"></i></a></td>
                <td><a href="/view-company-usage-log/{{ $company->companyName }}"><i class="fa fa-line-chart"></i></a></td>
                <td><a href="/edit-company/{{ $company->id }}"> <i class="lightGrey fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                <td><a href="/view-users/{{ $company->companyName }}"> <i class="fa fa-search" aria-hidden="true"></i></a></td>
                <td><a href="/export-to-xml/{{ $company->companyName }}"> <i class="fa fa-file-excel-o"></i></a></td>
                </tr>
        @endforeach
    </tbody>
</table>


@include('partials.footer')
@stop

@section('scripts')
<script>

</script>
@stop