@extends('master')

@section('title')
    Detailed Commercial Report
@stop

@section('styles')

@stop

@section('content')

@include('partials.nav')

<h1>Researched Report</h1>

<p>A report completely researched from scratch. This report includes a full assessment with the director and trade references. There are no financials, contracts, trade data and director assessments included.
   Business CIPC, Business Score, Business Adverse  (Judgments, Defaults etc.), Business Deeds, Business Trade References , Director (application signatory) assessment, Principal Detail , Principal Deeds, Principal links and affiliations, Principal Defaults, Standard Bank Code (24 hour bank code), Enquiry History
    </p>

   <hr style="margin-top: 10px;">

        <form id="mainForm" method="POST" action="/detailed-commercial" accept-charset="UTF-8" enctype="multipart/form-data">

            <div class="row">
            <h3>Your Contacts:</h3>
                <div class="large-6 columns">
                    <label>Name</label>
                    {{ $client->name }}
                </div>
                <div class="large-6 columns">
                     <label>Email</label>
                     {{ $client->email }}
                </div>
            </div>
            <hr>
            <div class="row">
            <h3>Inoxico Report Type</h3>
                <div class="large-3 columns">
                    <input id="quickview" type="radio" name="report" value="Quickview">
                    Quickview - <span>R{{ $inoxicoQuick }}</span>
                    <input id="priceTag" style="display:none;" value="R{{$inoxicoQuick}}">
                </div>
                <div class="large-3 columns">
                    <input id="basic" type="radio" name="report" value="Basic">
                    Basic - <span>R{{ $inoxicoBasic }}</span>
                    <input id="priceTag2" style="display:none;" value="R{{$inoxicoBasic}}">
                </div>
                <div class="large-3 columns">
                    <input id="detailed" type="radio" name="report" value="Detailed">
                    Detailed - <span>R{{ $inoxicoDetailed }}</span>
                    <input id="priceTag3" style="display:none;" value="R{{$inoxicoDetailed}}">
                </div>
                <div class="large-3 columns">
                    <input id="comprehensive" type="radio" name="report" value="Comprehensive">
                    Comprehensive - <span>R{{ $inoxicoComprehensive }}</span>
                    <input id="priceTag4" style="display:none;" value="R{{$inoxicoComprehensive}}">
                </div>
            </div>

            <hr>
			<div class="row">
			<h3>Debtors Details</h3>
			    <div class="large-6 columns">
			        <label>Company Name</label>
			        {{ Form::text('companyName') }}
			    </div>
			    <div class="large-6 columns">
                	 <label>Reg Number</label>
                	 {{ Form::text('DebtorsRegNumber') }}
                </div>
			</div>

			<div class="row">
			    <div class="large-6 columns">
			        <label>Contact Number</label>
			        {{ Form::text('debtorContacts') }}
			    </div>
			    <div class="large-6 columns">
			        <label>Email</label>
			        {{ Form::email('DebtorEmail') }}
			    </div>
			</div>

        <hr>

        <div class="row">
        <h3>Trade Reference 1</h3>
            <div class="large-4 columns">
                <label>Company Name</label>
                {{ Form::text('refCompany1') }}
            </div>
            <div class="large-4 columns">
                <label>Credit Terms applied for</label>
                {{ Form::select('termRef1', [
                         ''     => 'Please Select',
                         '30'   => '30 days',
                         '60'   => '60 days',
                         '90'   => '90 days',
                         '120+' => '120+ days'
                         ]
                                            ) }}
            </div>
            <div class="large-4 columns">
                <label>Credit Limit applied for (R)</label>
                {{ Form::select('creditLimitRef1', [
                     '' => 'Please Select',
                     '0-100,000' => '0-100,000',
                     '100,000 – 250,000' => '100,000 – 250,000',
                     '250,000 – 1,000,000' => '250,000 – 1,000,000',
                     '1,000,000 – 5,000,000' => '1,000,000 – 5,000,000',
                     '5,000,000+' => '5,000,000+'
                     ]
                                        ) }}
            </div>
        </div>

        <div class="row">
            <div class="large-4 columns">
                <label>Contact Person</label>
                {{ Form::text('contactPerson1') }}
            </div>
            <div class="large-4 columns">
                <label>Contact Number</label>
                {{ Form::text('contact1') }}
            </div>
            <div class="large-4 columns">
                <label>Consent obtained?</label>
                {{ Form::radio('consent1', 'YES', false) }}
                   Yes
                {{ Form::radio('consent1', 'NO', false) }}
                  No
            </div>
        </div>

<hr>

        <div class="row">
            <h3>Trade Reference 2</h3>
                <div class="large-4 columns">
                    <label>Company Name</label>
                    {{ Form::text('refCompany2') }}
                </div>
                <div class="large-4 columns">
                    <label>Credit Terms applied for</label>
                    {{ Form::select('termRef2', [
                             ''     => 'Please Select',
                             '30'   => '30 days',
                             '60'   => '60 days',
                             '90'   => '90 days',
                             '120+' => '120+ days'
                             ]
                                                ) }}
                </div>
                <div class="large-4 columns">
                    <label>Credit Limit applied for (R)</label>
                    {{ Form::select('creditLimitRef2', [
                         '' => 'Please Select',
                         '0-100,000' => '0-100,000',
                         '100,000 – 250,000' => '100,000 – 250,000',
                         '250,000 – 1,000,000' => '250,000 – 1,000,000',
                         '1,000,000 – 5,000,000' => '1,000,000 – 5,000,000',
                         '5,000,000+' => '5,000,000+'
                         ]
                                            ) }}
                </div>
            </div>

            <div class="row">
                <div class="large-4 columns">
                    <label>Contact Person</label>
                    {{ Form::text('contactPerson2') }}
                </div>
                <div class="large-4 columns">
                    <label>Contact Number</label>
                    {{ Form::text('contact2') }}
                </div>
                <div class="large-4 columns">
                    <label>Consent obtained?</label>
                    {{ Form::radio('consent2', 'YES', false) }}
                       Yes
                    {{ Form::radio('consent2', 'NO', false) }}
                      No
                </div>
        </div>

<hr>

        <div class="row">
        <h3>Trade Reference 3</h3>
            <div class="large-4 columns">
                <label>Company Name</label>
                {{ Form::text('refCompany3') }}
            </div>
            <div class="large-4 columns">
                <label>Credit Terms applied for</label>
                {{ Form::select('termRef3', [
                         ''     => 'Please Select',
                         '30'   => '30 days',
                         '60'   => '60 days',
                         '90'   => '90 days',
                         '120+' => '120+ days'
                         ]
                                            ) }}
            </div>
            <div class="large-4 columns">
                <label>Credit Limit applied for (R)</label>
                {{ Form::select('creditLimitRef3', [
                     '' => 'Please Select',
                     '0-100,000' => '0-100,000',
                     '100,000 – 250,000' => '100,000 – 250,000',
                     '250,000 – 1,000,000' => '250,000 – 1,000,000',
                     '1,000,000 – 5,000,000' => '1,000,000 – 5,000,000',
                     '5,000,000+' => '5,000,000+'
                     ]
                                        ) }}
            </div>
        </div>

        <div class="row">
            <div class="large-4 columns">
                <label>Contact Person</label>
                {{ Form::text('contactPerson3') }}
            </div>
            <div class="large-4 columns">
                <label>Contact Number</label>
                {{ Form::text('contact3') }}
            </div>
            <div class="large-4 columns">
                <label>Consent obtained?</label>
                {{ Form::radio('consent3', 'YES', false) }}
                   Yes
                {{ Form::radio('consent3', 'NO', false) }}
                  No
            </div>
        </div>

<hr>

<div class="row">
<h3>Banking Details</h3>
    <div class="large-6 columns">
        <label>Initials / Spaces in case of Company</label>
        {{ Form::text('initials') }}
    </div>
    <div class="large-6 columns">
        <label>Surname / Company name</label>
        {{ Form::text('surname') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>ID Number / numeric part of Company registration number</label>
        {{ Form::text('idNumber') }}
    </div>
    <div class="large-6 columns">
         <label>Account Number</label>
         {{ Form::text('accountNumber') }}
    </div>
</div>


<div class="row">
    <div class="large-6 columns">
         <label>Brach Code</label>
         {{ Form::text('branchCode') }}
    </div>
    <div class="large-6 columns">
         <label>Bank Account Type</label>
             {{ Form::select('accountType', [
                 '' => 'Please Select',
                 'current'             => 'current',
                 'savings'             => 'savings',
                 'bond'                => 'bond',
                 'credit card'         => 'credit card',
                 'subscription share'  => 'subscription share',
                 'not known'           => 'not known'
                                            ]
                                                ) }}
    </div>
</div>

<hr>

	    <div class="row">
	        <div class="large-12 columns">
	            <label>Attach Credit Application (browse)</label>
	            {{ Form::file('creditApplication') }}
	        </div>
	    </div>

	    <hr>

<p style="text-align: center;">Supplier:</p>
<img style="margin-left: auto;margin-right: auto;display: block;padding-top: 0rem;padding-bottom: 1rem;" width="15%" src="/img/Inoxico-logo-no-background.png" />
<hr>

<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> Inoxico</p>
		    <p><strong>Report type: </strong> <span id="response"></span> Inoxico Report</p>
		    <p><strong>Turnaround Time: </strong> 3-5 days</p>
		    <p><strong>Amount Ex VAT: </strong> <span id="price"></span></p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm Order</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>

		</form>

		{{ Form::close() }}
	</div>

@include('partials.footer')
@stop

@section('scripts')
<script>

    $('#submitBtn').click(function() {
    if(document.getElementById('quickview').checked) {
     $('#price').text($('#priceTag').val());
     $('#response').text('Quick View');
    }else if(document.getElementById('basic').checked) {
      $('#price').text($('#priceTag2').val());
      $('#response').text('Basic');
    }
    else if(document.getElementById('detailed').checked) {
          $('#price').text($('#priceTag3').val());
          $('#response').text('Detailed');
        }
    else if(document.getElementById('comprehensive').checked) {
          $('#price').text($('#priceTag4').val());
          $('#response').text('Comprehensive');
        }
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable confirm button after 1 click
    this.disabled = true;
}
</script>
@stop

