@extends('master')

@section('title')
   Credit Application Quote
@stop

@section('styles')
 <style>

input[type="text"], input[type="password"], input[type="date"], input[type="datetime"], input[type="datetime-local"], input[type="month"], input[type="week"], input[type="email"], input[type="number"], input[type="search"], input[type="tel"], input[type="time"], input[type="url"], input[type="color"], textarea {
    width: 220%;
}
 </style>
@stop

@section('content')

@include('partials.nav')

<h1>Credit Application – Request Quote</h1>

<hr style="margin-top: 10px;">

{{ Form::open(['url' => '/credit-application-quote', 'method' => 'POST', 'data-abide' => '','files' => true]) }}


<div class="row">
     <div class="large-4 columns">
         <!-- required -->
        @if($errors->first('company_name'))
            <label class="red">Client’s full registered name *</label>
            {{ Form::text('company_name', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Client’s full registered name *</label>
            {{ Form::text('company_name', '', ['class' => 'formFieldGrey']) }}
        @endif
     </div>
     <div class="large-4 columns">
        <!-- required -->
        @if($errors->first('termsOfPayment'))
            <label class="red">Terms of payment *</label>
            {{ Form::text('termsOfPayment', '', ['class' => 'formFieldGrey', 'placeholder' => '(i.e. 30 days from statement, or invoice, or delivery?)', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Terms of payment *</label>
            {{ Form::text('termsOfPayment', '', ['class' => 'formFieldGrey','placeholder' => '(i.e. 30 days from statement, or invoice, or delivery?)']) }}
        @endif
     </div>
     <div class="large-4 columns">
         <!-- required -->
        @if($errors->first('orders'))
            <label class="red">How do you receive orders? *</label>
            {{ Form::text('orders', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>How do you receive orders? *</label>
            {{ Form::text('orders', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
</div>


<div class="row">

     <div class="large-4 columns">
          @if($errors->first('quotations'))
          <label class="red" for="quotations">Do you issue quotations?</label>
            {{ Form::radio('quotations', 'YES', false) }}
              Yes
              {{ Form::radio('quotations', 'NO', false) }}
              No

          @else
          <label for="quotations">Do you issue quotations?<br>
          {{ Form::radio('quotations', 'YES', false) }}
            Yes
            {{ Form::radio('quotations', 'NO', false) }}
            No
          </label>
          @endif
     </div>
     <div class="large-4 columns">
            <!--<label class="" for="assemble">Do you assemble/use goods (from another supplier) to make your own product?<small class="red">{{ $errors->first('assemble') }}</small><br> -->
            @if($errors->first('assemble'))
            <label class="red" for="assemble">Do you use goods to make your own product?<label>
            {{ Form::radio('assemble', 'YES', false) }}
              Yes
              {{ Form::radio('assemble', 'NO', false) }}
              No
             @else
             <label>Do you use goods to make your own product?<label>
             {{ Form::radio('assemble', 'YES', false) }}
               Yes
               {{ Form::radio('assemble', 'NO', false) }}
               No
             @endif
     </div>
     <div class="large-4 columns">
           @if($errors->first('goods'))
           <label class="red" for="goods">Do you manufacture goods?</label>
           {{ Form::radio('goods', 'YES', false) }}
             Yes
             {{ Form::radio('goods', 'NO', false) }}
             No
           @else
           <label for="goods">Do you manufacture goods?</label>
            {{ Form::radio('goods', 'YES', false) }}
            Yes
            {{ Form::radio('goods', 'NO', false) }}
            No
            @endif
      </div>
</div>

<hr>
<div class="row">
    <div class="large-4 columns">
        @if($errors->first('buyFromSupplier'))
        <label class="red">Do you buy your product from a Supplier?</label>
        {{ Form::radio('buyFromSupplier', 'YES', false) }}
        Yes
        {{ Form::radio('buyFromSupplier', 'NO', false) }}
        No
        @else
        <label>Do you buy your product from a Supplier?</label>
        {{ Form::radio('buyFromSupplier', 'YES', false) }}
        Yes
        {{ Form::radio('buyFromSupplier', 'NO', false) }}
        No
        @endif
    </div>
    <div class="large-4 columns">
        @if($errors->first('agreement'))
        <label class="red">Do you have an agreement with your supplier?</label>
        {{ Form::radio('agreement', 'YES', false) }}
        Yes
        {{ Form::radio('agreement', 'NO', false) }}
        No
        @else
        <label>Do you have an agreement with your supplier?</label>
        {{ Form::radio('agreement', 'YES', false) }}
        Yes
        {{ Form::radio('agreement', 'NO', false) }}
        No
        @endif
    </div>
    <div class="large-4 columns">
        @if($errors->first('warrantee'))
        <label class="red">Does the product carry a warrantee?</label>
        {{ Form::radio('warrantee', 'YES', false) }}
        Yes
        {{ Form::radio('warrantee', 'NO', false) }}
        No
        @else
        <label>Does the product carry a warrantee?</label>
        {{ Form::radio('warrantee', 'YES', false) }}
        Yes
        {{ Form::radio('warrantee', 'NO', false) }}
        No
        @endif
    </div>
</div>
<hr>
<div class="row">
    <div class="large-6 columns">
        @if($errors->first('instructions'))
        <label class="red">Does the product come with instructions, labels, or a manual?</label>
        {{ Form::radio('instructions', 'YES', false) }}
        Yes
        {{ Form::radio('instructions', 'NO', false) }}
        No
        @else
        <label>Does the product come with instructions, labels, or a manual?</label>
        {{ Form::radio('instructions', 'YES', false) }}
        Yes
        {{ Form::radio('instructions', 'NO', false) }}
        No
        @endif
    </div>
    <div class="large-6 columns">
        @if($errors->first('interest'))
        <label class="red">Do you charge interest?</label>
        {{ Form::radio('interest', 'YES', false) }}
        Yes
        {{ Form::radio('interest', 'NO', false) }}
        No
        @else
        <label>Do you charge interest?</label>
        {{ Form::radio('interest', 'YES', false) }}
        Yes
        {{ Form::radio('interest', 'NO', false) }}
        No
        @endif
    </div>
</div>

<hr>

<div class="row">
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('determinePurchasePrice'))
            <label class="red">How do you determine the purchase price? *</label>
            {{ Form::text('determinePurchasePrice', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>How do you determine the purchase price? *</label>
            {{ Form::text('determinePurchasePrice', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
    <div class="large-6 columns">
    <!-- required -->
        @if($errors->first('dateInterest'))
            <label class="red">From which date do you charge interest? *</label>
            {{ Form::text('dateInterest', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>From which date do you charge interest? *</label>
            {{ Form::text('dateInterest', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
     <!-- required -->
        @if($errors->first('interestCharge'))
            <label class="red">What % interest do you (or do you want to) charge? *</label>
            {{ Form::text('interestCharge', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>What % interest do you (or do you want to) charge? *</label>
            {{ Form::text('interestCharge', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
    <div class="large-6 columns">
        @if($errors->first('suretyship'))
        <label class="red">Would you like your customer to sign a suretyship when completing your credit agreement?</label>
        {{ Form::radio('suretyship', 'YES', false) }}
        Yes
        {{ Form::radio('suretyship', 'NO', false) }}
        No
        @else
        <label>Would you like your customer to sign a suretyship when completing your credit agreement?</label>
        {{ Form::radio('suretyship', 'YES', false) }}
        Yes
        {{ Form::radio('suretyship', 'NO', false) }}
        No
        @endif
    </div>
</div>
<hr>
<div class="row">
    <div class="large-4 columns">
        @if($errors->first('returnPolicy'))
        <label class="red">Do you have a return policy? </label>
        {{ Form::radio('returnPolicy', 'YES', false) }}
        Yes
        {{ Form::radio('returnPolicy', 'NO', false) }}
        No
        @else
        <label>Do you have a return policy? </label>
        {{ Form::radio('returnPolicy', 'YES', false) }}
        Yes
        {{ Form::radio('returnPolicy', 'NO', false) }}
        No
        @endif
    </div>
    <div class="large-4 columns">
        <label>If you have a return policy, What is it?</label>
        {{ Form::text('returnPolicyDescription') }}
    </div>
     <div class="large-4 columns">
        <label>Company’s current credit application</label>
        {{ Form::file('creditApplication') }}
    </div>
</div>
<hr>
<div class="row">
    <div class="large-6 columns">
        @if($errors->first('testCertificate'))
        <label class="red">Does your product come with a test certificate?</label>
        {{ Form::radio('testCertificate', 'YES', false) }}
        Yes
        {{ Form::radio('testCertificate', 'NO', false) }}
        No
        @else
        <label>Does your product come with a test certificate?</label>
        {{ Form::radio('testCertificate', 'YES', false) }}
        Yes
        {{ Form::radio('testCertificate', 'NO', false) }}
        No
        @endif
    </div>
    <div class="large-6 columns">
        @if($errors->first('dangerous'))
        <label class="red">Is your product dangerous?</label>
        {{ Form::radio('dangerous', 'YES', false) }}
        Yes
        {{ Form::radio('dangerous', 'NO', false) }}
        No
        @else
        <label>Is your product dangerous?</label>
        {{ Form::radio('dangerous', 'YES', false) }}
        Yes
        {{ Form::radio('dangerous', 'NO', false) }}
        No
        @endif
    </div>
</div>

<hr>

<div class="row">
    <div class="large-12 columns">
        <!-- required -->
        @if($errors->first('termsInvoice'))
            <label class="red">What are the terms printed on your invoice? *</label>
            {{ Form::textarea('termsInvoice', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>What are the terms printed on your invoice? *</label>
            {{ Form::textarea('termsInvoice', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
</div>

<div class="row">
    <div class="large-12 columns">
        <!-- required -->
        @if($errors->first('termsDeliveryNote'))
            <label class="red">What are the terms printed on your delivery note? *</label>
            {{ Form::textarea('termsDeliveryNote', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>What are the terms printed on your delivery note? *</label>
            {{ Form::textarea('termsDeliveryNote', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
</div>

<div class="row">
    <div class="large-12 columns">
        <!-- required -->
        @if($errors->first('specialTerms'))
            <label class="red">Anything else you want to include? Special terms. </label>
            {{ Form::textarea('specialTerms', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Anything else you want to include? Special terms. *</label>
            {{ Form::textarea('specialTerms', '', ['class' => 'formFieldGrey']) }}
        @endif
    </div>
</div>

<div class="row">
    <div class="large-12 columns">
        <button class="myButton" type="submit">Request Quote</button>
    </div>
</div>

{{ Form:: close() }}

@include('partials.footer')

@stop