@extends('master')

@section('title')
     Bank Code Report Express
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<h1>Bank Code Express (4 hour delivery)</h1>

<p>A direct enquiry at the corresponding bank, allowing us to understand the strength of the applicants banking account and cash flow based on set amounts (usually double the amount the application is made for i.e. 50,000 credit would justify 100,000 bank code. This way you know you are safe.
   Standard Bank Code (24 hour bank code)
   Normal Bank code takes up to 24 hours to return and includes:
   Date account opened, Bank code descriptions, Bank Code for set amount
   Full and Genera Bank Code
   Bank code that includes: Date account opened, Bank code descriptions, Bank Code for set amount, Information relating to RD/bounced Cheques, Insolvency info, Bankruptcy info
   Urgent Bank Code
   A standard bank code with same day delivery if called for before 14h30 pm 0r next morning delivery thereafter.
    </p>

<hr style="margin-top: 10px;">

<form id="mainForm" method="POST" action="/bank-code-commercial" accept-charset="UTF-8" enctype="multipart/form-data">
<div class="row">
    <div class="large-4 columns">
         <!-- required -->
        @if($errors->first('businessName'))
            <label class="red">Business Name *</label>
            {{ Form::text('businessName', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Business Name *</label>
            <input type="text" id="businessName" name="businessName" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-4 columns">
        <!-- required -->
        @if($errors->first('accountHolder'))
            <label class="red">Account Holder *</label>
            {{ Form::text('accountHolder', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Holder *</label>
            <input type="text" id="accountHolder" name="accountHolder" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-4 columns">
        <!-- required -->
        @if($errors->first('idNumber'))
            <label class="red">Registration Number *</label>
            {{ Form::text('idNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Registration Number *</label>
            <input type="text" id="idNumber" name="idNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('bank'))
            <label class="red">Bank *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="bank">
              <option value="">Please Select</option>
              <option value ="ASBA" >ASBA</option>
              <option value ="NEDBANK" >NEDBANK</option>
              <option value ="STANDARD" >STANDARD BANK</option>
              <option value ="FNB" >FNB</option>
              <option value ="MERCANTILE" >MERCANTILE</option>
              <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
              <option value ="CITI BANK" >CITI BANK</option>
              <option value ="HSBC" >HSBC</option>
              <option value ="HBZ" >HBZ</option>
              <option value ="HABIB BANK" >HABIB BANK</option>
              <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @else
            <label>Bank *</label>
            <select name="bank" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
            <option value ="ASBA" >ASBA</option>
            <option value ="NEDBANK" >NEDBANK</option>
            <option value ="STANDARD" >STANDARD BANK</option>
            <option value ="FNB" >FNB</option>
            <option value ="MERCANTILE" >MERCANTILE</option>
            <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
            <option value ="CITI BANK" >CITI BANK</option>
            <option value ="HSBC" >HSBC</option>
            <option value ="HBZ" >HBZ</option>
            <option value ="HABIB BANK" >HABIB BANK</option>
            <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('country'))
            <label class="red">Bank Country *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="country">
              <option value ="ZAF" >South Africa</option>
              <option value ="BWA" >Botswana</option>
              <option value ="LSO" >Lesotho</option>
              <option value ="MWI" >Malawi</option>
              <option value ="NAM" >Namibia</option>
              <option value ="SWZ" >Swaziland</option>
              <option value ="ZWE" >Zimbabwe</option>
            </select>
        @else
            <label>Bank Country *</label>
            <select name="country" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
              <option value ="ZAF" >South Africa</option>
              <option value ="BWA" >Botswana</option>
              <option value ="LSO" >Lesotho</option>
              <option value ="MWI" >Malawi</option>
              <option value ="NAM" >Namibia</option>
              <option value ="SWZ" >Swaziland</option>
              <option value ="ZWE" >Zimbabwe</option>
            </select>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branch'))
            <label class="red">Branch Code *</label>
            {{ Form::text('branch', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Code *</label>
            <input type="text" id="branch" name="branch" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branchName'))
            <label class="red">Branch Name *</label>
            {{ Form::text('branchName', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Name *</label>
            <input type="text" id="branchName" name="branchName" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('terms'))
        <label class="red">Terms *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="terms">
          <option value ="30" >30 Days</option>
          <option value ="60" >60 Days</option>
          <option value ="90" >90 Days</option>
          <option value ="120" >120 Days</option>
          <option value ="COD" >Cash On Delivery</option>
          <option value ="12" >12 Months</option>
          <option value ="24" >24 Months</option>
          <option value ="36" >36 Months</option>
        </select>
    @else
        <label>Terms *</label>
        <select name="terms" onchange="checkFormsValidity();" required>
        <option value="">Please Select</option>
            <option value ="30" >30 Days</option>
            <option value ="60" >60 Days</option>
            <option value ="90" >90 Days</option>
            <option value ="120" >120 Days</option>
            <option value ="COD" >Cash On Delivery</option>
            <option value ="12" >12 Months</option>
            <option value ="24" >24 Months</option>
            <option value ="36" >36 Months</option>
        </select>
    @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('amount'))
            <label class="red">Amount *</label>
            {{ Form::text('amount', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Amount *</label>
            <input type="text" id="amount" name="amount" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('accountNumber'))
            <label class="red">Account Number *</label>
            {{ Form::text('accountNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Number *</label>
            <input type="text" id="accountNumber" name="accountNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('accountType'))
        <label class="red">Account Type *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="accountType">
          <option value="">Please Select</option>
          <option value ="CUR" >Savings</option>
          <option value ="CUR" >Cheque</option>
          <option value ="CUR" >Transmission</option>
          <option value ="BON" >Bond</option>
          <option value ="SUB" >Subscription Share acc</option>
        </select>
    @else
        <label>Account Type *</label>
        <select name="accountType" onchange="checkFormsValidity();" required>
        <option value="">Please Select</option>
            <option value ="CUR" >Savings</option>
            <option value ="CUR" >Cheque</option>
            <option value ="CUR" >Transmission</option>
            <option value ="BON" >Bond</option>
            <option value ="SUB" >Subscription Share acc</option>
        </select>
    @endif
    </div>
</div>


<h4 style="text-align: center;">Select Supplier</h4>
      <div class="row cc-selector" style="margin-bottom: 3rem;">
        <div class="large-6 columns">
                 <input id="compuscan" type="radio" name="response" value="Compuscan">
                 <label class="drinkcard-cc compuscan" for="compuscan">
                 <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">R{{$compuscanBankCodeExpress}}</p>
                 <input id="priceTag" style="display:none;" value="R{{$compuscanBankCodeExpress}}">
                 </label>
        </div>
        <div class="large-6 columns">
                <input id="transunion" type="radio" name="response" value="Transunion">
                <label class="drinkcard-cc transunion" for="transunion">
                <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">R{{$transunionBankCodeExpress}}</p>
                <input id="priceTag2" style="display:none;" value="R{{$transunionBankCodeExpress}}">
                </label>
        </div>
      </div>


<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> <span id="response"></span></p>
		    <p><strong>Report type: </strong> Commercial Bank Code Express Report</p>
		    <p><strong>Turnaround Time: </strong> 4 hours</p>
		    <p><strong>Amount Ex VAT: </strong> <span id="price"></span></p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm Order</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>


</form>
<hr>
@include('partials.footer')
@stop
@section('scripts')<!--
<script>
var sbmtBtn = document.getElementById("submitBtn");
sbmtBtn.disabled = true;

checkFormsValidity = function(){
var myforms = document.forms["mainForm"];
    if (myforms.checkValidity()) {
        sbmtBtn.disabled = false;
    } else {
        sbmtBtn.disabled = true;
    }
}
</script> -->
<script>
    $('#submitBtn').click(function() {
    if(document.getElementById('compuscan').checked) {
     $('#response').text($('#compuscan').val());
     $('#price').text($('#priceTag').val());
     //document.getElementById('providor')=='Compuscan';
    }else if(document.getElementById('transunion').checked) {
      $('#response').text($('#transunion').val());
      $('#price').text($('#priceTag2').val());
      //document.getElementById('providor')=='Transunion';
    }
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable
    this.disabled = true;
}
</script>
@stop