@extends('master')

@section('title')
    FAQs
@stop

@section('styles')
<link rel="stylesheet" href="{{ asset('css/faqs.css') }}">
@stop

@section('content')

@include('partials.nav')
<h1>Frequently Asked Questions</h1>

<div class="container">

<div class="faq-c">
  <div class="faq-q"><span class="faq-t">+</span>How do I re-set my password?</div>
  <div class="faq-a">
    <p>Click on the 'forgot password' link on the login page, fill in your details and receive a link to re-set your password. Please note : the link
    is valid for 60 minutes.
    </p>
  </div>
</div>

<div class="faq-c">
  <div class="faq-q"><span class="faq-t">+</span>How long does an express Bank Code request take?</div>
  <div class="faq-a">
    <p>If the bank code is called for before 14h30 pm it is deliveried after a maximum of 4 hours. </p>
  </div>
</div>

<div class="faq-c">
  <div class="faq-q"><span class="faq-t">+</span>I have requested a report and have not received it, what do I do?</div>
  <div class="faq-a">
    <p>Send your query to the Prestige Support Team and they will assists you. The turn-around time is 24 hours.</p>
  </div>
</div>

</div>
@include('partials.footer')
@stop

@section('scripts')
<script>
$(".faq-q").click( function () {
  var container = $(this).parents(".faq-c");
  var answer = container.find(".faq-a");
  var trigger = container.find(".faq-t");

  answer.slideToggle(200);

  if (trigger.hasClass("faq-o")) {
    trigger.removeClass("faq-o");
  }
  else {
    trigger.addClass("faq-o");
  }
});
</script>
@stop