@extends('master')

@section('title')
    Manage Users
@stop

@section('styles')

@stop

@section('content')

@include('partials.dashboard-menu')

<h1> <strong>{{ $company }}</strong> users</h1>

<div class="row">
    <div class="large-6 columns">
        <a style="text-decoration: none;" href="/new-user/{{$company}}"><button class="myButton">Add New User</button></a>
    </div>
     <div class="large-6 columns">
        <a style="text-decoration: none;" href="/view-company-usage-log/{{$company}}"><button class="myButton">Overall Usage Log</button></a>
     </div>
</div>


    <div class="comapanyTable">
            <table>
                <thead>
                    <tr>
                        <th width="10%%">User Name</th>
                        <th width="10%">Edit User Details</th>
                        <th  width="10%">User Transactions</th>
                        <th  width="10%">Delete User</th>
                    </tr>
                </thead>
                <tbody>
                    @foreach($users as $user)
                        <tr>
                            <td>{{ $user->name }}</td>
                            <td><a href="/edit-user/{{ $user->id }}"> <i class="fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                            <td><a href="/user-transactions/{{ $user->id }}"> <i class="fa fa-pencil-square-o" aria-hidden="true"></i> </a></td>
                            <td><a onclick="return Conform_Delete()" href="/deleteUser/{{ $user->id }}"> <i class="red fa fa-times" aria-hidden="true"></i></a></td>
                            </tr>
                    @endforeach
                </tbody>
            </table>

    </div>


<hr>

@include('partials.footer')
@stop

@section('scripts')
    <script>
        function Conform_Delete()
        {
           return confirm("Are You Sure Want to Delete this user?");
        }
    </script>
@stop