@extends('master')

@section('title')
    User Transactions
@stop

@section('styles')

@stop

@section('content')

@include('partials.dashboard-menu')

<h1> <strong>{{ $user->name }}</strong> from {{ $user->companyName }}</h1>
<a class="myButton" style="width:5% ;text-align: center;" href="/view-users/{{ $user->companyName }}"><i class="fa fa-chevron-left" aria-hidden="true"></i> Back</a>
@if($transactions!==NULL)
    <div class="transactionTable">
            <table>
                <thead>
                    <tr>
                        <th width="50%">Report</th>
                        <th width="50%">Created At</th></tr>
                </thead>
                <tbody>
                    @foreach($transactions as $transaction)
                        <tr>
                            <td>{{ $transaction->product }}</td>
                            <td>{{ $transaction->created_at }}</td>
                        </tr>
                    @endforeach
                </tbody>
            </table>
            <div class="row">
                <div class="large-12 columns">
                    <div class="pagination"> {{ $transactions->links() }} </div>
                </div>
            </div>
    </div>
@else
<h2>No transactions found</h2>
@endif
<hr>
@include('partials.footer')
@stop