@extends('master')

@section('title')
    New Company
@stop

@section('styles')

@stop

@section('content')

@include('partials.dashboard-menu')
	<h1>Add a new company</h1>

{{ Form::open(['files' => true]) }}
    <div class="row">
         <div class="large-12 columns">
            <label><i class="fa fa-building" aria-hidden="true"></i>Company Name <small class="red">{{ $errors->first('companyName') }}</small></label>
             {{ Form::text('companyName') }}
         </div>
    </div>

    <div class="row">
        <div class="large-6 columns">
            <label><i class="fa fa-address-book-o" aria-hidden="true"></i> Physical Address <small class="red">{{ $errors->first('address') }}</small></label>
            {{ Form::textarea('address') }}
        </div>
        <div class="large-6 columns">
            <label><i class="fa fa-address-book-o" aria-hidden="true"></i>Postal Address - ( <strong><input type="checkbox" id="checkBox" name="checkBox" onclick="enableDisable(this.checked, 'postal_address' )"> Same as Physical Address?</strong> )<small class="red">{{ $errors->first('postal_address') }}</small></label>
            {{ Form::textarea('postal_address', '', ['class' => 'postal_address', 'style'=>""]) }}
        </div>
    </div>

    <div class="row">
         <div class="large-6 columns">
            <label>Registration Number <small class="red">{{ $errors->first('registrationNumber') }}</small></label>
             {{ Form::text('registrationNumber') }}
         </div>
         <div class="large-6 columns">
            <label><i class="fa fa-address-book-o" aria-hidden="true"></i> VAT Number <small class="red">{{ $errors->first('VATNumber') }}</small></label>
            {{ Form::text('VATNumber') }}
         </div>
    </div>


    <div class="row">
         <div class="large-4 columns">
              <label><i class="fa fa-user" aria-hidden="true"></i> Contact Person Name <small class="red">{{ $errors->first('contact_person') }}</small></label>
                    {{ Form::text('contact_person') }}
         </div>
         <div class="large-4 columns">
              <label><i class="fa fa-envelope" aria-hidden="true"></i> Email <small class="red">{{ $errors->first('email') }}</small></label>
                    {{ Form::email('email') }}
         </div>
         <div class="large-4 columns">
               <label><i class="fa fa-phone" aria-hidden="true"></i> Telephone <small class="red">{{ $errors->first('telephone') }}</small></label>
                     {{ Form::text('telephone') }}
         </div>
    </div>

    <div class="row">
         <div class="large-4 columns">
              <label><i class="fa fa-user" aria-hidden="true"></i> Financial Director Name <small class="red">{{ $errors->first('contact_person') }}</small></label>
                    {{ Form::text('FD_person') }}
         </div>
         <div class="large-4 columns">
              <label><i class="fa fa-envelope" aria-hidden="true"></i> Financial Director Email <small class="red">{{ $errors->first('email') }}</small></label>
                    {{ Form::email('FD_email') }}
         </div>
         <div class="large-4 columns">
               <label><i class="fa fa-phone" aria-hidden="true"></i> Financial Director Telephone <small class="red">{{ $errors->first('telephone') }}</small></label>
                     {{ Form::text('FD_telephone') }}
         </div>
    </div>

    <div class="row">
         <div class="large-4 columns">
              <label><i class="fa fa-user" aria-hidden="true"></i> Financial Manager Name <small class="red">{{ $errors->first('contact_person') }}</small></label>
                    {{ Form::text('FM_contact_person') }}
         </div>
         <div class="large-4 columns">
              <label><i class="fa fa-envelope" aria-hidden="true"></i> Financial Manager Email <small class="red">{{ $errors->first('email') }}</small></label>
                    {{ Form::email('FM_email') }}
         </div>
         <div class="large-4 columns">
               <label><i class="fa fa-phone" aria-hidden="true"></i> Financial Manager Telephone <small class="red">{{ $errors->first('telephone') }}</small></label>
                     {{ Form::text('FM_telephone') }}
         </div>
    </div>

    <div class="row">
        <div class="large-12 columns">
            <button class="myButton" type="submit">Create Company</button>
        </div>
    </div>
{{ Form::close() }}
<hr>
@include('partials.footer')
@stop

@section('scripts')
<script>
jQuery(document).ready(function () {
   $("#checkBox").click(function () {
      $('.postal_address').attr("disabled", $(this).is(":checked"));
   });
});
</script>
@stop

