@extends('...master')

@section('title')
    Trade References
@stop

@section('styles')

@stop

@section('content')

@include('...partials.nav')
<h1>Inoxico Researched Report</h1>
<hr>
<h3>Add Trade References</h3>

@if($references!=NULL)
<div class="row">
    <div class="small-12 columns">
        <label>Trade References added</label>
        <table width="100%">
            <thead>
            <tr>
                <th width="8%">Name</th>
                <th width="10%">Email</th>
                <th width="10%">Number</th>
            </tr>
            </thead>
            <tbody>
            @foreach($references as $reference)
                <tr>
                    <td>{{ $reference->name }}</td>
                    <td>{{ $reference->email }}</td>
                    <td>{{ $reference->number }}</td>
                </tr>
            @endforeach
            </tbody>
        </table>
    </div>
</div>
@endif

{{ Form::open() }}
<div class="row">
   <div class="large-4 columns">
       <label>Name <small class="red">{{ $errors->first('name') }}</small></label>
       {{ Form::text('name') }}
   </div>
   <div class="large-4 columns">
      <label>Email <small class="red">{{ $errors->first('email') }}</small></label>
      {{ Form::email('email') }}
  </div>
  <div class="large-4 columns">
     <label>Number <small class="red">{{ $errors->first('number') }}</small></label>
     {{ Form::text('number') }}
 </div>
</div>


<button style="margin-left:auto;margin-right:auto;display:block;" class="myButton" type="submit">ADD REFERENCE</button>

{{ Form::close() }}
<hr>
<a href="/submitInoxicoResearchedReport/{{$id}}"><button class="myButton">SUBMIT</button></a>

@stop

@section('scripts')

@stop