@extends('master')

@section('title')
     Innoxico Researched Report
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<h1>Inoxico Researched Report</h1>

<p></p>

<hr style="margin-top: 10px;">

<form id="mainForm" method="POST" action="/inoxico-researched-report" accept-charset="UTF-8" enctype="multipart/form-data">
<div class="row">
    <div class="large-4 columns">
         <!-- required -->
        @if($errors->first('contactNumber'))
            <label class="red">Contact Number *</label>
            {{ Form::text('contactNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Contact Number *</label>
            <input type="text" id="contactNumber" name="contactNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-4 columns">
        <!-- required -->
        @if($errors->first('email'))
            <label class="red">Email *</label>
            {{ Form::email('email', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Email *</label>
            <input type="email" id="email" name="email" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-4 columns">
        <label>Report Currency</label>
        {{ Form::text('currency') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Do you have consent?</label>
        {{ Form::radio('consent1', 'YES', false) }}
           Yes
        {{ Form::radio('consent1', 'NO', false) }}
          No
    </div>
    <div class="large-6 columns">
        <label>Divulge to subject?</label>
        {{ Form::radio('subject', 'YES', false) }}
           Yes
        {{ Form::radio('subject', 'NO', false) }}
          No
    </div>
</div>

<div class="row">
    <div class="large-12 columns">
        <label>Any Special instructions?</label>
        {{ Form::textarea('instructions') }}
    </div>
</div>

<div class="row">
    <h4>Upload supporting files</h4>
    <div class="large-6 columns">
        <label>File 1</label>
        {{ Form::file('file1') }}
    </div>
    <div class="large-6 columns">
        <label>File 2</label>
        {{ Form::file('file2') }}
    </div>
</div>

<hr>

<h3>Bank Account Information</h3>

<div class="row">
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('accountHolder'))
            <label class="red">Account Holder Name *</label>
            {{ Form::text('accountHolder', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Holder Name *</label>
            <input type="text" id="accountHolder" name="accountHolder" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <label>Request Bank Code Now?</label>
        {{ Form::radio('bankCodeRequest', 'YES', false) }}
           Yes
        {{ Form::radio('bankCodeRequest', 'NO', false) }}
          No
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('bank'))
            <label class="red">Bank *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="bank">
              <option value="">Please Select</option>
              <option value ="ASBA" >ASBA</option>
              <option value ="NEDBANK" >NEDBANK</option>
              <option value ="STANDARD BANK" >STANDARD BANK</option>
              <option value ="FNB" >FNB</option>
              <option value ="MERCANTILE" >MERCANTILE</option>
              <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
              <option value ="CITI BANK" >CITI BANK</option>
              <option value ="HSBC" >HSBC</option>
              <option value ="HBZ" >HBZ</option>
              <option value ="HABIB BANK" >HABIB BANK</option>
              <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @else
            <label>Bank *</label>
            <select name="bank" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
            <option value ="ASBA" >ASBA</option>
            <option value ="NEDBANK" >NEDBANK</option>
            <option value ="STANDARD" >STANDARD BANK</option>
            <option value ="FNB" >FNB</option>
            <option value ="MERCANTILE" >MERCANTILE</option>
            <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
            <option value ="CITI BANK" >CITI BANK</option>
            <option value ="HSBC" >HSBC</option>
            <option value ="HBZ" >HBZ</option>
            <option value ="HABIB BANK" >HABIB BANK</option>
            <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('enquiryCurrency'))
            <label class="red">Enquiry Currency *</label>
            {{ Form::text('enquiryCurrency') }}
        @else
            <label>Enquiry Currency *</label>
            {{ Form::text('enquiryCurrency') }}
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branch'))
            <label class="red">Branch Code *</label>
            {{ Form::text('branch', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Code *</label>
            <input type="text" id="branch" name="branch" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branchName'))
            <label class="red">Branch Name *</label>
            {{ Form::text('branchName', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Name *</label>
            <input type="text" id="branchName" name="branchName" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('terms'))
        <label class="red">Enquiry Terms *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="terms">
          <option value ="30" >30 Days</option>
          <option value ="60" >60 Days</option>
          <option value ="90" >90 Days</option>
          <option value ="120" >120 Days</option>
          <option value ="COD" >Cash On Delivery</option>
          <option value ="12" >12 Months</option>
          <option value ="24" >24 Months</option>
          <option value ="36" >36 Months</option>
        </select>
    @else
        <label>Enquiry Terms *</label>
        <select name="terms" onchange="checkFormsValidity();" required>
        <option value="">Please Select</option>
            <option value ="30" >30 Days</option>
            <option value ="60" >60 Days</option>
            <option value ="90" >90 Days</option>
            <option value ="120" >120 Days</option>
            <option value ="COD" >Cash On Delivery</option>
            <option value ="12" >12 Months</option>
            <option value ="24" >24 Months</option>
            <option value ="36" >36 Months</option>
        </select>
    @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('amount'))
            <label class="red">Enquiry Amount *</label>
            {{ Form::text('amount', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Enquiry Amount *</label>
            <input type="text" id="amount" name="amount" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('accountNumber'))
            <label class="red">Account Number *</label>
            {{ Form::text('accountNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Number *</label>
            <input type="text" id="accountNumber" name="accountNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('accountType'))
        <label class="red">Account Type *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="accountType">
          <option value="">Please Select</option>
          <option value ="CUR" >Savings</option>
          <option value ="CUR" >Cheque</option>
          <option value ="CUR" >Transmission</option>
          <option value ="BON" >Bond</option>
          <option value ="SUB" >Subscription Share acc</option>
        </select>
    @else
        <label>Account Type *</label>
        <select name="accountType" onchange="checkFormsValidity();" required>
        <option value="">Please Select</option>
            <option value ="CUR" >Savings</option>
            <option value ="CUR" >Cheque</option>
            <option value ="CUR" >Transmission</option>
            <option value ="BON" >Bond</option>
            <option value ="SUB" >Subscription Share acc</option>
        </select>
    @endif
    </div>
</div>

<button class="myButton" id="submitBtn">NEXT</button>

</form>
<hr>
@include('partials.footer')
@stop

@section('scripts')
<script src={{ asset('https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js') }}></script>
<script>
    $('#submitBtn').click(function() {
    if(document.getElementById('compuscan').checked) {
     $('#response').text($('#compuscan').val());
     $('#price').text($('#priceTag').val());
     //document.getElementById('providor')=='Compuscan';
    }else if(document.getElementById('transunion').checked) {
      $('#response').text($('#transunion').val());
      $('#price').text($('#priceTag2').val());
      //document.getElementById('providor')=='Transunion';
    }
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable
    this.disabled = true;
}
</script>
@stop