@extends('master')

@section('title')
     Individual Report
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<div style="">
<h1>Principal Report</h1>

<p>This is an on-file report received from XDS that reflects the individual information on their personal capacity as a person or as a sole trader. This report is highly accurate as it takes personal accounts and CPA information into consideration. Consumer Payment History and Trends, Adverse Details, Hand Overs, Consumer Credit Score, Current Accounts, Enquiry History This report is namely used for principal sureties taken on goods or on sole trader accounts. The report is called for by an ID number and personal details.</p>

<hr style="margin-top: 10px;">
<form id="mainForm" method="POST" action="/consumer-credit-report" accept-charset="UTF-8" enctype="multipart/form-data">
<div class="row">
    <div class="large-6 columns">
    <!-- required -->
        @if($errors->first('idNumber'))
            <label class="red">ID Number *</label>
            {{ Form::text('idNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>ID Number *</label>
            <input type="text" id="idNumber" name="idNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('surname'))
            <label class="red">Surname *</label>
            {{ Form::text('surname', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Surname *</label>
            <input type="text" id="surname" name="surname" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>
<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('forename1'))
            <label class="red">Forename 1 *</label>
            {{ Form::text('forename1', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Forename 1 *</label>
            <input type="text" id="forename1" name="forename1" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <label>Forename 2 - <em>(if applicable)</em></label>
        {{ Form::text('forename2', '', ['class' => 'formFieldGrey']) }}
    </div>
</div>
<div class="row">
    <div class="large-6 columns">
            <label>Forename 3 - <em>(if applicable)</em></label>
            {{ Form::text('forename3') }}
    </div>
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('gender'))
        <label class="red">Gender *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="gender">
          <option value="">Please Select</option>
          <option value="M">Male</option>
          <option value="F">Female</option>
        </select>
    @else
        <label>Gender *</label>
        <select name="gender">
        <option value="">Please Select</option>
          <option value="M">Male</option>
          <option value="F">Female</option>
        </select>
    @endif
     </div>
</div>

<button class="myButton" id="submitBtn">Request</button>


</form>
<hr>
</div>
@include('partials.footer')

@stop

@section('scripts')
@stop