@extends('master')

@section('title')
     Transunion Express Bank Code
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.transunion-nav')
<h1>Commercial Express Bank Code (4 Hour Delivery)</h1>

<p>A direct enquiry at the corresponding bank, allowing us to understand the strength of the applicants banking account and cash flow based on set amounts (usually double the amount the application is made for i.e. 50,000 credit would justify 100,000 bank code. This way you know you are safe.
   Standard Bank Code (24 hour bank code)
   Normal Bank code takes up to 24 hours to return and includes:
   Date account opened, Bank code descriptions, Bank Code for set amount
   Full and Genera Bank Code
   Bank code that includes: Date account opened, Bank code descriptions, Bank Code for set amount, Information relating to RD/bounced Cheques, Insolvency info, Bankruptcy info
   Urgent Bank Code
   A standard bank code with same day delivery if called for before 14h30 pm 0r next morning delivery thereafter.
    </p>

<hr style="margin-top: 10px;">

{{ Form::open() }}
<div class="row">
    <div class="large-6 columns">
        <label>Account Holder <small class="red">{{ $errors->first('accountHolder') }}</small></label>
        {{ Form::text('accountHolder') }}
    </div>
    <div class="large-6 columns">
        <label>Registration Number or ID <small class="red">{{ $errors->first('idNumber') }}</small></label>
        {{ Form::text('idNumber') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Bank Name <small class="red">{{ $errors->first('bank') }}</small></label>
        {{ Form::select('bank', [
                 '' => 'Please Select',
                 'ASBA' => 'ASBA',
                 'NEDBANK' => 'NEDBANK',
                 'STANDARD' => 'STANDARD BANK',
                 'FNB' => 'FNB',
                 'MERCANTILE' => 'MERCANTILE',
                 'BANK OF ATHENS' => 'BANK OF ATHENS',
                 'CITI BANK' => 'CITI BANK',
                 'HSBC' => 'HSBC',
                 'HBZ' => 'HBZ',
                 'HABIB BANK' => 'HABIB BANK',
                 'INVESTEC' => 'INVESTEC']
                                    ) }}
    </div>

</div>

<div class="row">
    <div class="large-6 columns">
        <label>Branch Code <small class="red">{{ $errors->first('branch') }}</small></label>
        {{ Form::text('branch') }}
    </div>
    <div class="large-6 columns">
         <label>Branch Name <small class="red">{{ $errors->first('branchName') }}</small></label>
         {{ Form::text('branchName') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Terms <small class="red">{{ $errors->first('terms') }}</small></label>
        <select id="terms" name="terms" >
            <option value ="30" >30 Days</option>
            <option value ="60" >60 Days</option>
            <option value ="90" >90 Days</option>
            <option value ="120" >120 Days</option>
            <option value ="COD" >Cash On Delivery</option>
            <option value ="12" >12 Months</option>
            <option value ="24" >24 Months</option>
            <option value ="36" >36 Months</option>
        </select>
    </div>
    <div class="large-6 columns">
        <label>Amount <small class="red">{{ $errors->first('amount') }}</small></label>
        {{ Form::text('amount') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
         <label>Account Number <small class="red">{{ $errors->first('accountNumber') }}</small></label>
         {{ Form::text('accountNumber') }}
    </div>
    <div class="large-6 columns">
        <label>Account Type <small class="red">{{ $errors->first('accountType') }}</small></label>
         <select id="accountType" name="accountType" >
            <option value ="CUR" >Savings</option>
            <option value ="CUR" >Check</option>
            <option value ="CUR" >Transmission</option>
            <option value ="BON" >Bond</option>
            <option value ="SUB" >Subscription Share acc</option>
         </select>
    </div>
</div>

<button class="myButton" type="submit">Submit</button>

{{ Form::close() }}
<hr>
@include('partials.footer')
@stop