@extends('master')

@section('title')
     Individual Report
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<div style="">
<h1>Principal Report</h1>

<p>This is an on-file report received from Compuscan that reflects the individual information on their personal capacity as a person or as a sole trader. This report is highly accurate as it takes personal accounts and CPA information into consideration. Consumer Payment History and Trends, Adverse Details, Hand Overs, Consumer Credit Score, Current Accounts, Enquiry History This report is namely used for principal sureties taken on goods or on sole trader accounts. The report is called for by an ID number and personal details.</p>

<hr style="margin-top: 10px;">
<form id="mainForm" method="POST" action="/individual-report" accept-charset="UTF-8" enctype="multipart/form-data">
<div class="row">
    <div class="large-6 columns">
    <!-- required -->
        @if($errors->first('idNumber'))
            <label class="red">ID Number *</label>
            {{ Form::text('idNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>ID Number *</label>
            <input type="text" id="idNumber" name="idNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('surname'))
            <label class="red">Surname *</label>
            {{ Form::text('surname', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Surname *</label>
            <input type="text" id="surname" name="surname" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>
<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('forename1'))
            <label class="red">Forename 1 *</label>
            {{ Form::text('forename1', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Forename 1 *</label>
            <input type="text" id="forename1" name="forename1" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <label>Forename 2 - <em>(if applicable)</em></label>
        {{ Form::text('forename2', '', ['class' => 'formFieldGrey']) }}
    </div>
</div>
<div class="row">
    <div class="large-6 columns">
            <label>Forename 3 - <em>(if applicable)</em></label>
            {{ Form::text('forename3') }}
    </div>
    <div class="large-6 columns">
    <!-- required -->
    @if($errors->first('gender'))
        <label class="red">Gender *</label>
        <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="gender">
          <option value="">Please Select</option>
          <option value="M">Male</option>
          <option value="F">Female</option>
        </select>
    @else
        <label>Gender *</label>
        <select name="gender">
        <option value="">Please Select</option>
          <option value="M">Male</option>
          <option value="F">Female</option>
        </select>
    @endif
     </div>
</div>

<p>Supplier:</p>

    <div class="row cc-selector">
        <div class="large-4 columns">
            <input id="compuscan" type="radio" name="response" value="Compuscan">
            <label class="drinkcard-cc compuscan" for="compuscan">
                <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">Price: R{{$compuscanPrincipalPrice}}</p>
            </label>

            <input id="priceTag" style="display:none;" value="R{{$compuscanPrincipalPrice}}">
        </div>

        <div class="large-4 columns">
            <input id="xds" type="radio" name="response" value="xds">
            <label class="drinkcard-cc xds" for="xds">
                <br><br><br><p style="text-align: initial;margin-top: 0.5rem;">Price: R{{$xdsPrincipalPrice}}</p>
            </label>

            <input id="priceTag3" style="display:none;" value="R{{$xdsPrincipalPrice}}">
        </div>
    </div>


<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> <span id="response"></span></p>
		    <p><strong>Report type: </strong> Principal Report</p>
		    <p><strong>Turnaround Time: </strong> Instant</p>
		    <p><strong>Amount Ex VAT: </strong> <span id="price"></span></p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>

</form>
<hr>
</div>
@include('partials.footer')

@stop

@section('scripts') <!--
<script>
var sbmtBtn = document.getElementById("submitBtn");
sbmtBtn.disabled = true;

checkFormsValidity = function(){
var myforms = document.forms["mainForm"];
    if (myforms.checkValidity()) {
        sbmtBtn.disabled = false;
    } else {
        sbmtBtn.disabled = true;
    }
}
</script> -->
<script>
    $('#submitBtn').click(function() {
        if(document.getElementById('compuscan').checked) {
            $('#response').text($('#compuscan').val());
            $('#price').text($('#priceTag').val());
            //document.getElementById('providor')=='Compuscan';
        }
        else if(document.getElementById('xds').checked) {
            $('#response').text($('#xds').val());
            $('#price').text($('#priceTag2').val());
        }
    });


    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable
    this.disabled = true;
}
</script>
@stop