@extends('master')

@section('title')
     Bank Code Report
@stop

@section('styles')
<style>

</style>
@stop

@section('content')

@include('partials.nav')
<h1>Principal Bank Code (24 Hour Delivery)</h1>
<p>A direct enquiry at the corresponding bank, allowing us to understand the strength of the applicants banking account and cash flow based on set amounts (usually double the amount the application is made for i.e. 50,000 credit would justify 100,000 bank code. This way you know you are safe.
   Standard Bank Code (24 hour bank code)</p>
<hr style="margin-top: 10px;">

<form id="mainForm" method="POST" action="/individual-bank-code" accept-charset="UTF-8" enctype="multipart/form-data">

<div class="row">
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('surname'))
            <label class="red">Surname *</label>
            {{ Form::text('surname', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Surname *</label>
            <input type="text" id="surname" name="surname" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('forename1'))
            <label class="red">Forename 1 *</label>
            {{ Form::text('forename1', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Forename 1 *</label>
            <input type="text" id="forename1" name="forename1" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>Forename2 - <em>(if applicable)</em></label>
        {{ Form::text('forename2')}}
    </div>
    <div class="large-6 columns">
        <label>Forename3 - <em>(if applicable)</em></label>
        {{ Form::text('forename3') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
         <!-- required -->
        @if($errors->first('accountHolder'))
            <label class="red">Account Holder *</label>
            {{ Form::text('accountHolder', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Holder *</label>
            <input type="text" id="accountHolder" name="accountHolder" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('idNumber'))
            <label class="red">ID Number *</label>
            {{ Form::text('idNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>ID Number *</label>
            <input type="text" id="idNumber" name="idNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('bank'))
            <label class="red">Bank *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="bank">
              <option value="">Please Select</option>
              <option value ="ASBA" >ASBA</option>
              <option value ="NEDBANK" >NEDBANK</option>
              <option value ="STANDARD" >STANDARD BANK</option>
              <option value ="FNB" >FNB</option>
              <option value ="MERCANTILE" >MERCANTILE</option>
              <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
              <option value ="CITI BANK" >CITI BANK</option>
              <option value ="HSBC" >HSBC</option>
              <option value ="HBZ" >HBZ</option>
              <option value ="HABIB BANK" >HABIB BANK</option>
              <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @else
            <label>Bank *</label>
            <select name="bank" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
            <option value ="ASBA" >ASBA</option>
            <option value ="NEDBANK" >NEDBANK</option>
            <option value ="STANDARD" >STANDARD BANK</option>
            <option value ="FNB" >FNB</option>
            <option value ="MERCANTILE" >MERCANTILE</option>
            <option value ="BANK OF ATHENS" >BANK OF ATHENS</option>
            <option value ="CITI BANK" >CITI BANK</option>
            <option value ="HSBC" >HSBC</option>
            <option value ="HBZ" >HBZ</option>
            <option value ="HABIB BANK" >HABIB BANK</option>
            <option value ="INVESTEC" >INVESTEC</option>
            </select>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('country'))
            <label class="red">Bank Country *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="country">
              <option value ="ZAF" >South Africa</option>
              <option value ="BWA" >Botswana</option>
              <option value ="LSO" >Lesotho</option>
              <option value ="MWI" >Malawi</option>
              <option value ="NAM" >Namibia</option>
              <option value ="SWZ" >Swaziland</option>
              <option value ="ZWE" >Zimbabwe</option>
            </select>
        @else
            <label>Bank Country *</label>
            <select name="country" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
              <option value ="ZAF" >South Africa</option>
              <option value ="BWA" >Botswana</option>
              <option value ="LSO" >Lesotho</option>
              <option value ="MWI" >Malawi</option>
              <option value ="NAM" >Namibia</option>
              <option value ="SWZ" >Swaziland</option>
              <option value ="ZWE" >Zimbabwe</option>
            </select>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branchName'))
            <label class="red">Branch Name *</label>
            {{ Form::text('branchName', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Name *</label>
            <input type="text" id="branchName" name="branchName" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('branchCode'))
            <label class="red">Branch Code *</label>
            {{ Form::text('branchCode', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Branch Code *</label>
            <input type="text" id="branchCode" name="branchCode" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('accountNumber'))
            <label class="red">Account Number *</label>
            {{ Form::text('accountNumber', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Account Number *</label>
            <input type="text" id="accountNumber" name="accountNumber" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('accountType'))
            <label class="red">Account Type *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="accountType">
              <option value="">Please Select</option>
              <option value ="CUR" >Savings</option>
              <option value ="CUR" >Cheque</option>
              <option value ="CUR" >Transmission</option>
              <option value ="BON" >Bond</option>
              <option value ="SUB" >Subscription Share acc</option>
            </select>
        @else
            <label>Account Type *</label>
            <select name="accountType" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
                <option value ="CUR" >Savings</option>
                <option value ="CUR" >Cheque</option>
                <option value ="CUR" >Transmission</option>
                <option value ="BON" >Bond</option>
                <option value ="SUB" >Subscription Share acc</option>
            </select>
        @endif
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('amount'))
            <label class="red">Amount *</label>
            {{ Form::text('amount', '', ['class' => 'formFieldGrey', 'style'=>"border: 2px solid rgba(255, 0, 0, 0.3)"]) }}
        @else
            <label>Amount *</label>
            <input type="text" id="amount" name="amount" class="formFieldGrey" onkeyup="checkFormsValidity();" required/>
        @endif
    </div>
    <div class="large-6 columns">
        <!-- required -->
        @if($errors->first('terms'))
            <label class="red">Terms *</label>
            <select style="border: 2px solid rgba(255, 0, 0, 0.3);" name="terms">
              <option value ="30" >30 Days</option>
              <option value ="60" >60 Days</option>
              <option value ="90" >90 Days</option>
              <option value ="120" >120 Days</option>
              <option value ="COD" >Cash On Delivery</option>
              <option value ="12" >12 Months</option>
              <option value ="24" >24 Months</option>
              <option value ="36" >36 Months</option>
            </select>
        @else
            <label>Terms *</label>
            <select name="terms" onchange="checkFormsValidity();" required>
            <option value="">Please Select</option>
                <option value ="30" >30 Days</option>
                <option value ="60" >60 Days</option>
                <option value ="90" >90 Days</option>
                <option value ="120" >120 Days</option>
                <option value ="COD" >Cash On Delivery</option>
                <option value ="12" >12 Months</option>
                <option value ="24" >24 Months</option>
                <option value ="36" >36 Months</option>
            </select>
        @endif
    </div>
</div>

<p style="text-align:center;">Supplier:</p>
<img style="margin-left:auto;margin-right: auto;display: block" width="10%" src="/img/compuscan_logo.jpg" />
<p style="text-align:center;">R{{$compuscanBankCodePrincipal}}</p>

<a href="#" data-reveal-id="offer11"><button class="myButton" id="submitBtn">Request</button></a>

        <div id="offer11" class="reveal-modal small" data-reveal aria-labelledby="modalTitle" aria-hidden="true" role="dialog">
		    <h1>Confirm Order</h1>
		    <p><strong>Service Provider: </strong> Compuscan</p>
		    <p><strong>Report type: </strong> Principal Bank Code</p>
		    <p><strong>Turnaround Time: </strong> 24 hours</p>
		    <p><strong>Amount Ex VAT: </strong> R{{$compuscanBankCodePrincipal}}</p>
		    <hr>
		    <span style="color:#daab2b;">By selecting “confirm Order” you agree to the terms and conditions provided to you in terms of your agreement with Prestige.</span>
            <hr>
           <button id="submit" class="myButton" type="submit">Confirm</button>
            <a class="close-reveal-modal" aria-label="Close">&#215;</a>
        </div>

</form>
<hr>
@include('partials.footer')
@stop

@section('scripts')
<script src={{ asset('https://ajax.googleapis.com/ajax/libs/jquery/3.1.1/jquery.min.js') }}></script>
<script>
var sbmtBtn = document.getElementById("submitBtn");
sbmtBtn.disabled = true;

checkFormsValidity = function(){
var myforms = document.forms["mainForm"];
    if (myforms.checkValidity()) {
        sbmtBtn.disabled = false;
    } else {
        sbmtBtn.disabled = true;
    }
}
</script>
<script>
    $('#submitBtn').click(function() {
         $('#lname').text($('#lastname').val());
         $('#fname').text($('#firstname').val());
    });

    $('#submit').click(function(){
        $('#mainForm').submit();
    });
</script>
<script>
document.getElementById("submit").onclick = function() {
    //disable
    this.disabled = true;
}
</script>
@stop