@extends('master')

@section('title')
    Compuscan Report
@stop

@section('styles')

@stop

@section('content')

@include('partials.compuscan-nav')

<h1>Detailed Report</h1>

<p>A report completely researched from scratch by Compuscan. This report includes a full assessment with the director and trade references. There are no financials, contracts, trade data and director assessments included.
   Business CIPC, Business Score, Business Adverse  (Judgments, Defaults etc.), Business Deeds, Business Trade References , Director (application signatory) assessment, Principal Detail , Principal Deeds, Principal links and affiliations, Principal Defaults, Standard Bank Code (24 hour bank code), Enquiry History
</p>

   <hr style="margin-top: 10px;">

        {{ Form::open(['url' => '/full-reports', 'method' => 'POST', 'data-abide' => '','files' => true]) }}


            <div class="row">
            <h3>Your Contact Details:</h3>
                <div class="large-4 columns">
                    <label>Name</label>
                    {{ Form::text('clientName') }}
                </div>
                <div class="large-4 columns">
                    <label>Tel</label>
                    {{ Form::text('ClientTel') }}
                </div>
                <div class="large-4 columns">
                     <label>Email</label>
                     {{ Form::email('clientEmail') }}
                </div>
            </div>


			<div class="row">
			<h3>Debtors Details</h3>
			    <div class="large-6 columns">
			        <label>Company Name</label>
			        {{ Form::text('companyName') }}
			    </div>
			    <div class="large-6 columns">
                	 <label>Reg Number</label>
                	 {{ Form::text('DebtorsRegNumber') }}
                </div>
			</div>

			<div class="row">
			    <div class="large-6 columns">
			        <label>Contact Number</label>
			        {{ Form::text('debtorContacts') }}
			    </div>
			    <div class="large-6 columns">
			        <label>Email</label>
			        {{ Form::email('DebtorEmail') }}
			    </div>
			</div>

<hr>

        <div class="row">
        <h3>Trade Reference 1</h3>
            <div class="large-4 columns">
                <label>Company Name</label>
                {{ Form::text('refCompany1') }}
            </div>
            <div class="large-4 columns">
                <label>Term</label>
                {{ Form::select('termRef1', [
                         ''     => 'Please Select',
                         '30'   => '30 days',
                         '60'   => '60 days',
                         '90'   => '90 days',
                         '120+' => '120+ days'
                         ]
                                            ) }}
            </div>
            <div class="large-4 columns">
                <label>Credit Limit (R)</label>
                {{ Form::select('creditLimitRef1', [
                     '' => 'Please Select',
                     '0-100,000' => '0-100,000',
                     '100,000 – 250,000' => '100,000 – 250,000',
                     '250,000 – 1,000,000' => '250,000 – 1,000,000',
                     '1,000,000 – 5,000,000' => '1,000,000 – 5,000,000',
                     '5,000,000+' => '5,000,000+'
                     ]
                                        ) }}
            </div>
        </div>

        <div class="row">
            <div class="large-6 columns">
                <label>Contact Person</label>
                {{ Form::text('contactPerson1') }}
            </div>
            <div class="large-6 columns">
                <label>Contact Number</label>
                {{ Form::text('contact1') }}
            </div>
        </div>

<hr>

        <div class="row">
        <h3>Trade Reference 2</h3>
            <div class="large-4 columns">
                <label>Company Name</label>
                {{ Form::text('refCompany2') }}
            </div>
            <div class="large-4 columns">
                <label>Term</label>
                {{ Form::select('termRef2', [
                         ''     => 'Please Select',
                         '30'   => '30 days',
                         '60'   => '60 days',
                         '90'   => '90 days',
                         '120+' => '120+ days'
                         ]
                                            ) }}
            </div>
            <div class="large-4 columns">
                <label>Credit Limit (R)</label>
                {{ Form::select('creditLimitRef2', [
                     ''                         => 'Please Select',
                     '0-100,000'                => '0-100,000',
                     '100,000 – 250,000'        => '100,000 – 250,000',
                     '250,000 – 1,000,000'      => '250,000 – 1,000,000',
                     '1,000,000 – 5,000,000'    => '1,000,000 – 5,000,000',
                     '5,000,000+'               => '5,000,000+'
                     ]
                                        ) }}
            </div>
        </div>

            <div class="row">
                <div class="large-6 columns">
                    <label>Contact Person</label>
                    {{ Form::text('contactPerson2') }}
                </div>
                <div class="large-6 columns">
                    <label>Contact Number</label>
                    {{ Form::text('contact2') }}
                </div>
        </div>

<hr>

        <div class="row">
        <h3>Trade Reference 3</h3>
            <div class="large-4 columns">
                <label>Company Name</label>
                {{ Form::text('refCompany3') }}
            </div>
            <div class="large-4 columns">
                <label>Term</label>
                {{ Form::select('termRef3', [
                         '' => 'Please Select',
                         '30' => '30 days',
                         '60' => '60 days',
                         '90' => '90 days',
                         '120+' => '120+ days'
                         ]
                                            ) }}
            </div>
            <div class="large-4 columns">
                <label>Credit Limit (R)</label>
                {{ Form::select('creditLimitRef3', [
                     '' => 'Please Select',
                     '0-100,000' => '0-100,000',
                     '100,000 – 250,000' => '100,000 – 250,000',
                     '250,000 – 1,000,000' => '250,000 – 1,000,000',
                     '1,000,000 – 5,000,000' => '1,000,000 – 5,000,000',
                     '5,000,000+' => '5,000,000+'
                     ]
                                        ) }}
            </div>
        </div>
        <div class="row">
            <div class="large-6 columns">
                <label>Contact Person</label>
                {{ Form::text('contactPerson3') }}
            </div>
            <div class="large-6 columns">
                <label>Contact Number</label>
                {{ Form::text('contact3') }}
            </div>
        </div>

<hr>

<div class="row">
<h3>Banking Details</h3>
    <div class="large-6 columns">
        <label>Initials / Spaces in case of Company</label>
        {{ Form::text('initials') }}
    </div>
    <div class="large-6 columns">
        <label>Surname / Company name</label>
        {{ Form::text('surname') }}
    </div>
</div>

<div class="row">
    <div class="large-6 columns">
        <label>ID Number / numeric part of Company registration number</label>
        {{ Form::text('idNumber') }}
    </div>
    <div class="large-6 columns">
         <label>Account Number</label>
         {{ Form::text('accountNumber') }}
    </div>
</div>


<div class="row">
    <div class="large-6 columns">
         <label>Brach Code</label>
         {{ Form::text('branchCode') }}
    </div>
    <div class="large-6 columns">
         <label>Bank Account Type</label>
             {{ Form::select('accountType', [
                 '' => 'Please Select',
                 'current'             => 'current',
                 'savings'             => 'savings',
                 'bond'                => 'bond',
                 'credit card'         => 'credit card',
                 'subscription share'  => 'subscription share',
                 'not known'           => 'not known'
                                            ]
                                                ) }}
    </div>
</div>

<hr>

	    <div class="row">
	        <div class="large-12 columns">
	            <label>Attach Credit Application (browse)</label>
	            {{ Form::file('creditApplication') }}
	        </div>
	    </div>

		<button class="myButton" type="submit">Submit</button>

		{{ Form::close() }}
	</div>

<hr>
@include('partials.footer')
@stop

@section('scripts')

@stop

