<?php

/*
|--------------------------------------------------------------------------
| Application Routes
|--------------------------------------------------------------------------
|
| Here is where you can register all of the routes for an application.
| It's a breeze. Simply tell Laravel the URIs it should respond to
| and give it the Closure to execute when that URI is requested.
|
*/

Route::get('commercial-report2','CompuscanController@serveCompuscanCommercial');
Route::post('commercial-report2','CompuscanController@handleCompuscanCommercial');

Route::get('/','PagesController@serverLogin');
Route::post('/', 'PagesController@handleLogin');
Route::get('password/recovery', 'RemindersController@getRemind');
Route::get('password/reset/{token}', 'RemindersController@getReset');

Route::get('terms-and-conditions','PagesController@serverTermsConditions');
Route::post('password/recovery', 'RemindersController@postRemind');
Route::post('password/reset/{token}', 'RemindersController@postReset');


Route::group(['before' => 'auth'], function(){

    Route::get('xds-test','PagesController@showXDS');
    Route::post('xds-test','PagesController@serverXDS');

Route::get('home','PagesController@home');
Route::get('register','PagesController@serverRegister');
Route::get('dashboard', 'PagesController@serverDashboard');
Route::get('logout', 'PagesController@handleLogout')->after('invalidate-browser-cache');
Route::get('BCS-request','PagesController@serverBCS');
Route::get('OFS-request','PagesController@serverOFS');
Route::get('manage-users','PagesController@serverManageUsers');
Route::get('new-user/{user}','PagesController@newUser');
Route::get('edit-user/{user}','PagesController@serveEditUser');
Route::get('deleteUser/{user}', 'PagesController@deleteUser');
Route::get('manage-invoices','PagesController@manageInvoices');
Route::get('AVSR-request','PagesController@serverAVSR');
Route::get('BCS-reponse1','PagesController@view1stResponse');
Route::get('check-BCS-status','PagesController@showJobBCSstatus');
Route::get('BCS-results','PagesController@seeBCSResults');
Route::get('bank-code-options','PagesController@serverBankCodeOption');
Route::get('support','PagesController@serverSupport');
Route::get('set-pricing/{company}','PagesController@serverSetPricing');
Route::get('quote','PagesController@serverQuote');
Route::get('debt-collection', 'PagesController@debtCollection');

Route::get('bureau-reports-menu','PagesController@viewBureauMenu');
Route::get('query-system','PagesController@serverQuerySystem');
Route::get('management-dashboard','PagesController@serverManagementDashboard');
Route::get('client-usage','PagesController@serverClientUsage');
Route::get('edit-pricing/{name}','PagesController@serverEditPricing');
Route::get('generate-invoice/{company}','PagesController@serverGenerateInvoice');
Route::get('collect-BCS-report','PagesController@showJobBCSstatus');
Route::get('check-BCS-status','PagesController@showJobBCSstatus');
Route::get('compuscan-report','PagesController@serverPossibleMatchSearch');
Route::get('full-company-search','PagesController@serverFullCompanySearch');
Route::get('previous-company-search','PagesController@serverPreviousCompanySearch');
Route::get('normal-search','PagesCotroller@serverNormalSearch');
Route::get('full-reports','PagesController@serverFullReport');
Route::get('possible-match-result/{request}','PagesController@serverPossibleMatchResult');
Route::get('compuscan-reports','PagesController@serverCompuscanReports');
Route::get('serverCollectAVSR','PagesController@serverCollectAVSR');
Route::get('collect-OFS-report','PagesController@serverCollectOFS');
Route::get('collect-AVSR-report','PagesController@serverCollectAVSR');
Route::get('AVSR-report','PagesController@viewAVSRReport');
    Route::get('compuscan-express-bank-code','PagesController@serverCompuscanExpressBankCode');
    Route::get('compuscan-principal-express-bank-code','PagesController@serverCompuscanPrincipalExpressBankCode');
    Route::get('transunion-principal-bank-code','PagesController@serverTransunionPrincipalBankCode');
    Route::get('status-researched-report','PagesController@serverStatusDataResearchedReport');
    Route::get('transunion-researched-report','PagesController@serverTransunionResearchedReport');
    Route::get('transunion-express-bank-code','PagesController@handleTransunionExpressBankCode');
    Route::get('compuscan-company-deeds','PagesController@serverCompanyDeeds');
    Route::get('transunion-investigate','PagesController@serverTransunionInvestigate');
    Route::get('on-file-commercial','PagesController@serverOnFileCommercial');
    Route::get('express-basic-commercial','PagesController@serverExpressBasicCommercial');
    Route::get('express-basic-principal','PagesController@serverExpressBasicPrincipal');
    Route::get('basic-principal','PagesController@serverBasicPrincipal');
    Route::get('basic-commercial','PagesController@serverBasicCommercial');
    Route::get('inoxico-researched-report','InoxicoController@serverInoxicoResearchedReport');
    Route::get('references/{id}','InoxicoController@serveReferences');
    Route::get('submitInoxicoResearchedReport/{id}','InoxicoController@submitInoxicoResearchedReport');

    Route::get('detailed-commercial','PagesController@serverDetailedCommercial');

    Route::get('detailed-principal','PagesController@serverDetailedPrincipal');
    Route::get('comprehensive-commercial','PagesController@serverComprehensiveCommercial');
    Route::get('comprehensive-principal','PagesController@serverComprehensivePrincipal');
    Route::get('all-users','PagesController@serverAllUser');
    Route::get('add-new-user','PagesController@AddNewUser');
    Route::get('link-user/{id}','PagesController@serverLinkUserMultipleCompanies');
    Route::get('credit-application-quote','PagesController@serverCreditApplicationQuote');
    Route::get('guarantees','PagesController@serverGuarantee');
    Route::get('training-on-legislation','PagesController@serverTraining');
    Route::get('disclaimer','PagesController@serverDisclaimer');
    Route::get('select-company','PagesController@serverSelectCompany');
    Route::get('choose-company/{company}','PagesController@serverChooseCompany');
    Route::get('user-search', 'PagesController@searchUser');
    Route::get('dashboard-search', 'PagesController@searchManagementDashboard');
    Route::get('company-search', 'PagesController@searchCompany');
    Route::get('view-company/{company}','PagesController@handleViewCompany');
    Route::get('preview','PagesController@handleBannerPreview');
    Route::get('banner-image','PagesController@serverBannerImage');



Route::get('business-commercial-report','PagesController@serverBusinessCommercialReport');
Route::get('business-bank-code','PagesController@serverBusinessBankCode');
    Route::get('transunion-bank-code','PagesController@serverTransunionBusinessBankCode');
Route::get('individual-bank-code','PagesController@serverIndividualBankCode');
Route::get('individual-report','PagesController@serverIndividualReport');
Route::get('credit-check2','PagesController@serverCreditCheck2');
    Route::post('on-file-commercial','PagesController@handleOnFileCommercial');
    Route::post('add-new-user','PagesController@handleAddNewUser');
    Route::post('user-search','PagesController@handleUserSearch');
    Route::post('credit-application-quote','PagesController@handleCreditApplicationQuote');
    Route::post('training-on-legislation','PagesController@handleTraining');
    Route::post('guarantees','PagesController@handleGuarantees');
    Route::post('set-pricing/{company}','PagesController@handleSetPricing');
    Route::post('inoxico-researched-report','InoxicoController@handleInoxicoResearchedReport');
    Route::post('references/{id}','InoxicoController@handleReferences');

Route::get('credit-check2BCD','PagesController@serverCreditCheck2BCD');
Route::get('individual-deeds','PagesController@serverIndividualDeeds');
Route::get('deeds','PagesController@serverDeeds');
Route::get('business-summary','PagesController@serverBusinessSummary');
Route::get('full-bank-code','PagesController@serverFullBankCode');
Route::get('debtor-ranking-and-monitoring','PagesController@serverDebtorRanking');
    Route::get('view-company-usage-log/{company}','PagesController@serverViewCompanyUsageLog');
    Route::get('view-users/{companyName}','PagesController@serverViewUsers');
    Route::get('quick-fix-report','PagesController@serverQuickFixReport');
    Route::get('bank-code-commercial','PagesController@serverBankCodeCommercial');
    Route::get('principal-bank-code','PagesController@serverPrincipalBankCode');
    Route::get('bank-code-commercial-express','PagesController@serverBankCodeCommercialExpress');
    Route::get('principal-bank-code-express','PagesController@serverPrincipalBankCodeExpress');
    Route::get('pricing/{company}','PagesController@serverPricing');
    Route::get('set-standard-pricing/{company}','PagesController@setStandardPricing');
    Route::get('customise-pricing/{company}','PagesController@serverEditPricing2');
    Route::get('redirect-admin','PagesController@setToAdmin');
    Route::get('export-to-xml/{company}','PagesController@exportToExcel');


    Route::get('prestige-support','PagesController@serverPrestigeSupport');
    Route::get('DMS-support','PagesController@serverDMSupport');
    Route::get('user-transactions/{id}','PagesController@serverViewTransations');
    Route::get('manage-invoices','PagesController@serverManageInvoices');
    Route::get('banner','PagesController@serverBanner');
    Route::get('FAQs','PagesController@serverFAQs');
    Route::get('new-company','PagesController@serverNewCompany');
    Route::get('edit-company/{id}','PagesController@serverEditCompany');
    Route::get('company-transaction-list/{company}',
        [
            'as' => 'management.view-users',
            'uses' => 'PagesController@excel'
        ]);


    Route::get('consumer-credit-report','XDSController@serveXDSPrincipal');
    Route::post('consumer-credit-report', 'XDSController@handleXDSPrincipal');

    Route::get('consumer-credit-report2','CompuscanController@serveCompuscanPrincipal');
    Route::post('consumer-credit-report2', 'CompuscanController@handleCompuscanPrincipal');

    Route::get('commercial-report','XDSController@serveXDSCommercial');
    Route::post('commercial-report','XDSController@handleXDSCommercial');
});

Route::get('report-download', function() {

    define("DOMPDF_ENABLE_PHP", true);

    //assign values to variables
    $strUser = "Statusdata_uat";
    $strPwd = "93eb1864";

    $client = new SoapClient ("https://www.uat.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters = array ("strUser"=>$strUser, "strPwd"=>$strPwd);
    $configQry = $client->Login ($parameters);
    //remove special characters
    $ticket = preg_replace ("~/~", "\\\\", $configQry->LoginResult);

    $ConnectTicket = $ticket;
    $EnquiryReason = "";
    $ProductId = "15";
    $IdNumber = "0000000000000";
    $PassportNo = "019860308";
    $FirstName = "A";
    $Surname = "ANWAR";
    $BirthDate = '1986-03-08';
    $YourReference = "";
    $VoucherCode = "";
    $client = new SoapClient ("https://www.uat.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters = array (
        "ConnectTicket"=>$ConnectTicket,"EnquiryReason"=>$EnquiryReason,"ProductId"=>$ProductId,"IdNumber"=>$IdNumber,"PassportNo"=>$PassportNo,"FirstName"=>$FirstName,"Surname"=>$Surname,"BirthDate"=>$BirthDate,"YourReference"=>$YourReference,
        "VoucherCode"=>$VoucherCode);
    $configQry = $client-> ConnectConsumerMatch ($parameters);

    $result = $configQry->ConnectConsumerMatchResult;
    $loadResult = simplexml_load_string($result);
    $enquiryID = $loadResult->ConsumerDetails->EnquiryID;
    $enquiryResultID = $loadResult->ConsumerDetails->EnquiryResultID;
    $EnquiryID = $enquiryID;
    $EnquiryResultID = $enquiryResultID;
    $ProductID='15';
    $BonusXML ='';
    $client = new SoapClient ("https://www.uat.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters=array("ConnectTicket"=>$ConnectTicket,'EnquiryID'=>$EnquiryID,'EnquiryResultID'=>$EnquiryResultID,'ProductID'=>$ProductID,'EnquiryID'=>$EnquiryID,'BonusXML'=>$BonusXML);
    $configQry2 = $client->ConnectGetResult($parameters);

    $result2 = $configQry2->ConnectGetResultResult;
    $loadResult2 = simplexml_load_string($result2);

    $ConsumerTelephoneHistory = array();

    $story = new SimpleXMLElement($result2);
    $json_string = json_encode($story);
    $result_array = json_decode($json_string,TRUE);


    foreach($result_array['ConsumerTelephoneHistory'] as $item)
    {
        array_push($ConsumerTelephoneHistory,$item);
    }

    //Report
    $reportId = $loadResult2->ReportInformation->ReportID;
    $reportName = $loadResult2->ReportInformation->ReportName;

    $consumerDisplayText = $loadResult2->ConsumerDirectorSummary->DisplayText;
    $NumberOfCompanyDirector = $loadResult2->ConsumerDirectorSummary->NumberOfCompanyDirector;

    //ConsumerJudgement - list

    $consumerJudgementDisplayText = $loadResult2->ConsumerJudgement->Displaytext;
    $consumerJudgementCaseFilingDate = $loadResult2->ConsumerJudgement->CaseFilingDate;
    $consumerJudgementCaseType = $loadResult2->ConsumerJudgement->CaseType;
    $consumerJudgementLastUpdatedDate = $loadResult2->ConsumerJudgement->LastUpdatedDate;
    $consumerJudgementPlaintiffName = $loadResult2->ConsumerJudgement->PlaintiffName;
    $consumerJudgementDisputeAmt = $loadResult2->ConsumerJudgement->DisputeAmt;
    $consumerJudgementCaseReason = $loadResult2->ConsumerJudgement->CaseReason;
    $consumerJudgementCourtName = $loadResult2->ConsumerJudgement->CourtName;
    $consumerJudgementCaseNumber = $loadResult2->ConsumerJudgement->CaseNumber;
    $consumerJudgementAttorneyName = $loadResult2->ConsumerJudgement->AttorneyName;
    $consumerJudgementTelephoneNo = $loadResult2->ConsumerJudgement->TelephoneNo;
    $consumerJudgementComments = $loadResult2->ConsumerJudgement->Comments;

    //ConsumerAdminOrder

    $consumerAdminOrderDisplayText = $loadResult2->ConsumerAdminOrder->DisplayText;
    $consumerAdminOrderCaseFilingDate = $loadResult2->ConsumerAdminOrder->CaseFilingDate;
    $consumerAdminOrderCaseType = $loadResult2->ConsumerAdminOrder->CaseType;
    $consumerAdminOrderLastUpdatedDate = $loadResult2->ConsumerAdminOrder->LastUpdatedDate;
    $consumerAdminOrderPlaintiffName = $loadResult2->ConsumerAdminOrder->PlaintiffName;
    $consumerAdminOrderDisputeAmt = $loadResult2->ConsumerAdminOrder->DisputeAmt;
    $consumerAdminOrderCaseReason = $loadResult2->ConsumerAdminOrder->CaseReason;
    $consumerAdminOrderCourtName = $loadResult2->ConsumerAdminOrder->CourtName;
    $consumerAdminOrderCaseNumber = $loadResult2->ConsumerAdminOrder->CaseNumber;
    $consumerAdminOrderAttorneyName = $loadResult2->ConsumerAdminOrder->AttorneyName;
    $consumerAdminOrderTelephoneNo = $loadResult2->ConsumerAdminOrder->TelephoneNo;
    $consumerAdminOrderComments = $loadResult2->ConsumerAdminOrder->Comments;

    //ConsumerSequestration

    $consumerSequestrationDisplayText = $loadResult2->ConsumerSequestration->DisplayText;
    $consumerSequestrationCaseFilingDate = $loadResult2->ConsumerSequestration->CaseFilingDate;
    $consumerSequestrationCaseType = $loadResult2->ConsumerSequestration->CaseType;
    $consumerSequestrationLastUpdatedDate = $loadResult2->ConsumerSequestration->LastUpdatedDate;
    $consumerSequestrationPlaintiffName = $loadResult2->ConsumerSequestration->PlaintiffName;
    $consumerSequestrationDisputeAmt = $loadResult2->ConsumerSequestration->DisputeAmt;
    $consumerSequestrationCaseReason = $loadResult2->ConsumerSequestration->CaseReason;
    $consumerSequestrationCourtName = $loadResult2->ConsumerSequestration->CourtName;
    $consumerSequestrationCaseNumber = $loadResult2->ConsumerSequestration->CaseNumber;
    $consumerSequestrationAttorneyName = $loadResult2->ConsumerSequestration->AttorneyName;
    $consumerSequestrationTelephoneNo = $loadResult2->ConsumerSequestration->TelephoneNo;
    $consumerSequestrationComments = $loadResult2->ConsumerSequestration->Comments;

    //ConsumerEnquiryHistory - list

    $consumerEnquiryHistoryDisplayText = $loadResult2->ConsumerEnquiryHistory->DisplayText;
    $consumerEnquiryHistoryEnquiryDate = $loadResult2->ConsumerEnquiryHistory->EnquiryDate;
    $consumerEnquiryHistorySubscriberName = $loadResult2->ConsumerEnquiryHistory->SubscriberName;
    $consumerEnquiryHistorySubscriberBusinessTypeDesc = $loadResult2->ConsumerEnquiryHistory->SubscriberBusinessTypeDesc;
    $consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc = $loadResult2->ConsumerEnquiryHistory->CreditGrantorEnquiryReasonDesc;
    $consumerEnquiryHistorySubscriberContact = $loadResult2->ConsumerEnquiryHistory->SubscriberContact;

    //ConsumerDebtReviewStatus

    $consumerDebtReviewStatusDisplayText = $loadResult2->ConsumerDebtReviewStatus->DisplayText;
    $consumerDebtReviewStatusIDno = $loadResult2->ConsumerDebtReviewStatus->IDno;
    $consumerDebtReviewStatusFirstName = $loadResult2->ConsumerDebtReviewStatus->FirstName;
    $consumerDebtReviewStatusSurName = $loadResult2->ConsumerDebtReviewStatus->SurName;
    $consumerDebtReviewStatusBirthDate = $loadResult2->ConsumerDebtReviewStatus->BirthDate;
    $consumerDebtReviewStatusDebtReviewStatusDate = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatusDate;
    $consumerDebtReviewStatusDebtCounsellorName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorName;
    $consumerDebtReviewStatusDebtCounsellorFirstName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorFirstName;
    $consumerDebtReviewStatusDebtCounsellorSurName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorSurName;
    $consumerDebtReviewStatusDebtCounsellorTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorTelephoneNo;
    $consumerDebtReviewStatusDebtReviewStatusCode = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatusCode;
    $consumerDebtReviewStatusHomeTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->HomeTelephoneNo;
    $consumerDebtReviewStatusWorkTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->WorkTelephoneNo;
    $consumerDebtReviewStatusCellularNo = $loadResult2->ConsumerDebtReviewStatus->CellularNo;
    $consumerDebtReviewStatusDebtReviewStatus = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatus;
    $consumerDebtReviewStatusDebtCounsellorRegistrationNo = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorRegistrationNo;

    //ConsumerDirectorShipLink - list

    $consumerDirectorShipLinkDisplayText = $loadResult2->ConsumerDirectorShipLink->DisplayText;
    $consumerDirectorShipLinkDirectorDesignationDesc = $loadResult2->ConsumerDirectorShipLink->DirectorDesignationDesc;
    $consumerDirectorShipLinkAppointmentDate = $loadResult2->ConsumerDirectorShipLink->AppointmentDate;
    $consumerDirectorShipLinkCommercialName = $loadResult2->ConsumerDirectorShipLink->CommercialName;
    $consumerDirectorShipLinkRegistrationNo = $loadResult2->ConsumerDirectorShipLink->RegistrationNo;
    $consumerDirectorShipLinkPhysicalAddress = $loadResult2->ConsumerDirectorShipLink->PhysicalAddress;
    $consumerDirectorShipLinkTelephoneNo =$loadResult2->ConsumerDirectorShipLink->TelephoneNo;
    $consumerDirectorShipLinkSICDesc = $loadResult2->ConsumerDirectorShipLink->SICDesc;
    $consumerDirectorShipLinkDirectorStatus = $loadResult2->ConsumerDirectorShipLink->DirectorStatus;

    //ConsumerPropertyInformation

    $consumerPropertyInformationDisplayText = $loadResult2->ConsumerPropertyInformation->DisplayText;
    $consumerPropertyInformationAuthorityName = $loadResult2->ConsumerPropertyInformation->AuthorityName;
    $consumerPropertyInformationTownshipName = $loadResult2->ConsumerPropertyInformation->TownshipName;
    $consumerPropertyInformationStandNo = $loadResult2->ConsumerPropertyInformation->StandNo;/*
        PortionNo = PortionNo;
        TitleDeedNo = TitleDeedNo;
        BuyerName = BuyerName;
        BuyerTypeCode = BuyerTypeCode;
        BuyerIDNo = BuyerIDNo;
        BuyerMaritalStatusCode = BuyerMaritalStatusCode;
        SellerName = SellerName;
        SellerTypeCode = SellerTypeCode;
        SellerIDNo = SellerIDNo;
        SellerMaritalStatusCode = SellerMaritalStatusCode;
        TransferDate = TransferDate;
        RegistrarName = RegistrarName;
        OldTitleDeedNo = OldTitleDeedNo;
        AttorneyFirmNo = AttorneyFirmNo;
        AttorneyFileNo = AttorneyFileNo;
        TitleDeedFeeAmt = TitleDeedFeeAmt;
        PropertyTypeCode = PropertyTypeCode;
        StreetNo = StreetNo;
        StreetName = StreetName;
        SuburbName = SuburbName; */

    //ConsumerAddressHistory - list

    $consumerAddressHistoryDisplayText = $loadResult2->ConsumerAddressHistory->DisplayText;
    $consumerAddressHistoryConsumerAddressID = $loadResult2->ConsumerAddressHistory->ConsumerAddressID;
    $consumerAddressHistoryAddressType = $loadResult2->ConsumerAddressHistory->AddressType;
    $consumerAddressHistoryAddressTypeInd = $loadResult2->ConsumerAddressHistory->AddressTypeInd;
    $consumerAddressHistoryAddress1 = $loadResult2->ConsumerAddressHistory->Address1;
    $consumerAddressHistoryAddress2 = $loadResult2->ConsumerAddressHistory->Address2;
    $consumerAddressHistoryAddress3 = $loadResult2->ConsumerAddressHistory->Address3;
    $consumerAddressHistoryAddress4 = $loadResult2->ConsumerAddressHistory->Address4;
    $consumerAddressHistoryPostalCode = $loadResult2->ConsumerAddressHistory->PostalCode;
    $consumerAddressHistoryAddress =$loadResult2->ConsumerAddressHistory-> Address;
    $consumerAddressHistoryLastUpdatedDate = $loadResult2->ConsumerAddressHistory->LastUpdatedDate;
    $consumerAddressHistoryFirstReportedDate = $loadResult2->ConsumerAddressHistory->FirstReportedDate;

    //ConsumerTelephoneHistory - list

    $consumerTelephoneHistoryDisplayText = $loadResult2->ConsumerTelephoneHistory->DisplayText;
    $consumerTelephoneHistoryConsumerTelephoneID = $loadResult2->ConsumerTelephoneHistory->ConsumerTelephoneID;
    $consumerTelephoneHistoryTelephoneType = $loadResult2->ConsumerTelephoneHistory->TelephoneType;
    $consumerTelephoneHistoryTelephoneTypeInd = $loadResult2->ConsumerTelephoneHistory->TelephoneTypeInd;
    $consumerTelephoneHistoryTelCode =$loadResult2->ConsumerTelephoneHistory->TelCode;
    $consumerTelephoneHistoryTelephoneNo = $loadResult2->ConsumerTelephoneHistory->TelephoneNo;
    $consumerTelephoneHistoryEmailAddress = $loadResult2->ConsumerTelephoneHistory->EmailAddress;
    $consumerTelephoneHistoryLastUpdatedDate = $loadResult2->ConsumerTelephoneHistory->LastUpdatedDate;
    $consumerTelephoneHistoryFirstReportedDate = $loadResult2->ConsumerTelephoneHistory->FirstReportedDate;

    //ConsumerEmploymentHistory
    $consumerEmploymentHistoryDisplayText = $loadResult2->ConsumerEmploymentHistory->DisplayText;
    $consumerEmploymentHistoryEmployerDetail = $loadResult2->ConsumerEmploymentHistory->EmployerDetail;
    $consumerEmploymentHistoryDesignation = $loadResult2->ConsumerEmploymentHistory->Designation;
    $consumerEmploymentHistoryLastUpdatedDate = $loadResult2->ConsumerEmploymentHistory->LastUpdatedDate;
    $consumerEmploymentHistoryFirstReportedDate = $loadResult2->ConsumerEmploymentHistory->FirstReportedDate;

    //ConsumerDetail
    $consumerDetailDisplayText = $loadResult2->ConsumerDetail->DisplayText;
    $consumerDetailConsumerID = $loadResult2->ConsumerDetail->ConsumerID;
    $consumerDetailInitials = $loadResult2->ConsumerDetail->Initials;
    $consumerDetailFirstName = $loadResult2->ConsumerDetail->FirstName;
    $consumerDetailSecondName = $loadResult2->ConsumerDetail->SecondName;
    $consumerDetailThirdName = $loadResult2->ConsumerDetail->ThirdName;
    $consumerDetailSurname = $loadResult2->ConsumerDetail->Surname;
    $consumerDetailMaidenName =$loadResult2->ConsumerDetail->MaidenName;
    $consumerDetailIDNo = $loadResult2->ConsumerDetail->IDNo;
    $consumerDetailPassportNo =$loadResult2->ConsumerDetail->PassportNo;
    $consumerDetailBirthDate = $loadResult2->ConsumerDetail->BirthDate;
    $consumerDetailGender =$loadResult2->ConsumerDetail->Gender;
    $consumerDetailTitleDesc =$loadResult2->ConsumerDetail->TitleDesc;
    $consumerDetailMaritalStatusDesc =$loadResult2->ConsumerDetail->MaritalStatusDesc;
    $consumerDetailPrivacyStatus =$loadResult2->ConsumerDetail->PrivacyStatus;
    $consumerDetailResidentialAddress =$loadResult2->ConsumerDetail->ResidentialAddress;
    $consumerDetailPostalAddress =$loadResult2->ConsumerDetail->PostalAddress ;
    $consumerDetailHomeTelephoneNo =$loadResult2->ConsumerDetail->HomeTelephoneNo;
    $consumerDetailWorkTelephoneNo = $loadResult2->ConsumerDetail->WorkTelephoneNo;
    $consumerDetailCellularNo =$loadResult2->ConsumerDetail->CellularNo;
    $consumerDetailEmailAddress = $loadResult2->ConsumerDetail->EmailAddress;
    $consumerDetailEmployerDetail = $loadResult2->ConsumerDetail->EmployerDetail;
    $consumerDetailReferenceNo = $loadResult2->ConsumerDetail->ReferenceNo;
    $consumerDetailExternalReference = $loadResult2->ConsumerDetail->ExternalReference;

    //ConsumerFraudIndicatorsSummary
    $consumerFraudIndicatorsSummaryDisplayText = $loadResult2->ConsumerFraudIndicatorsSummary->DisplayText;
    $consumerFraudIndicatorsSummarySAFPSListingYN = $loadResult2->ConsumerFraudIndicatorsSummary->SAFPSListingYN;
    $consumerFraudIndicatorsSummaryHomeAffairsVerificationYN = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsVerificationYN;
    $consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsDeceasedStatus;
    $consumerFraudIndicatorsSummaryEmployerFraudVerificationYN = $loadResult2->ConsumerFraudIndicatorsSummary->EmployerFraudVerificationYN;
    $consumerFraudIndicatorsSummaryProtectiveVerificationYN =$loadResult2->ConsumerFraudIndicatorsSummary->ProtectiveVerificationYN;
    $consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsDeceasedDate;


    //ConsumerPropertyInformationSummary

    $consumerPropertyInformationSummaryDisplayText = $loadResult2->ConsumerPropertyInformationSummary->DisplayText;
    $consumerPropertyInformationSummaryTotalProperty = $loadResult2->ConsumerPropertyInformationSummary->TotalProperty;
    $consumerPropertyInformationSummaryPurchasePrice = $loadResult2->ConsumerPropertyInformationSummary->PurchasePrice;


    //ConsumerEmailHistory - list

    $consumerEmailHistoryDisplayText = $loadResult2->ConsumerEmailHistory->DisplayText;
    $consumerEmailHistoryEmailAddress = $loadResult2->ConsumerEmailHistory->EmailAddress;
    $consumerEmailHistoryLastUpdatedDate = $loadResult2->ConsumerEmailHistory->LastUpdatedDate;

    $pdf = \PDF::loadView('pdf.xdsConsumerReport', [
        'loadResult2' => $loadResult2,
        'result_array' => $result_array,
        'ConsumerTelephoneHistory' => $ConsumerTelephoneHistory,
        'consumerDetailDisplayText' => $consumerDetailDisplayText,
        'consumerDetailConsumerID' => $consumerDetailConsumerID,
        'consumerDetailInitials' => $consumerDetailInitials,
        'consumerDetailFirstName' => $consumerDetailFirstName,
        'consumerDetailSecondName' => $consumerDetailSecondName,
        'consumerDetailThirdName' => $consumerDetailThirdName,
        'consumerDetailSurname' => $consumerDetailSurname,
        'consumerDetailMaidenName' => $consumerDetailMaidenName,
        'consumerDetailIDNo' => $consumerDetailIDNo,
        'consumerDetailPassportNo' => $consumerDetailPassportNo,
        'consumerDetailBirthDate' => $consumerDetailBirthDate,
        'consumerDetailGender' => $consumerDetailGender,
        'consumerDetailTitleDesc' => $consumerDetailTitleDesc,
        'consumerDetailMaritalStatusDesc' => $consumerDetailMaritalStatusDesc,
        'consumerDetailPrivacyStatus' => $consumerDetailPrivacyStatus,
        'consumerDetailResidentialAddress' => $consumerDetailResidentialAddress,
        'consumerDetailPostalAddress' => $consumerDetailPostalAddress,
        'consumerDetailHomeTelephoneNo' => $consumerDetailHomeTelephoneNo,
        'consumerDetailWorkTelephoneNo' => $consumerDetailWorkTelephoneNo,
        'consumerDetailCellularNo' => $consumerDetailCellularNo,
        'consumerDetailEmailAddress' => $consumerDetailEmailAddress,
        'consumerDetailEmployerDetail' => $consumerDetailEmployerDetail,
        'consumerDetailReferenceNo' => $consumerDetailReferenceNo,
        'consumerDetailExternalReference' => $consumerDetailExternalReference,

        'consumerPropertyInformationSummaryDisplayText' => $consumerPropertyInformationSummaryDisplayText,
        'consumerPropertyInformationSummaryTotalProperty' => $consumerPropertyInformationSummaryTotalProperty,
        'consumerPropertyInformationSummaryPurchasePrice' => $consumerPropertyInformationSummaryPurchasePrice,

        'consumerFraudIndicatorsSummaryDisplayText' => $consumerFraudIndicatorsSummaryDisplayText,
        'consumerFraudIndicatorsSummarySAFPSListingYN' => $consumerFraudIndicatorsSummarySAFPSListingYN,
        'consumerFraudIndicatorsSummaryHomeAffairsVerificationYN' => $consumerFraudIndicatorsSummaryHomeAffairsVerificationYN,
        'consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus' => $consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus,
        'consumerFraudIndicatorsSummaryEmployerFraudVerificationYN' => $consumerFraudIndicatorsSummaryEmployerFraudVerificationYN,
        'consumerFraudIndicatorsSummaryProtectiveVerificationYN' => $consumerFraudIndicatorsSummaryProtectiveVerificationYN,
        'consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate' => $consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate,

        'consumerDebtReviewStatusDisplayText' => $consumerDebtReviewStatusDisplayText,
        'consumerDebtReviewStatusFirstName' => $consumerDebtReviewStatusFirstName,
        'consumerDebtReviewStatusSurName' => $consumerDebtReviewStatusSurName,
        'consumerDebtReviewStatusBirthDate' => $consumerDebtReviewStatusBirthDate,
        'consumerDebtReviewStatusDebtReviewStatusDate' => $consumerDebtReviewStatusDebtReviewStatusDate,
        'consumerDebtReviewStatusDebtCounsellorName' => $consumerDebtReviewStatusDebtCounsellorName,
        'consumerDebtReviewStatusDebtCounsellorFirstName' => $consumerDebtReviewStatusDebtCounsellorFirstName,
        'consumerDebtReviewStatusDebtCounsellorSurName' => $consumerDebtReviewStatusDebtCounsellorSurName,
        'consumerDebtReviewStatusDebtCounsellorTelephoneNo' => $consumerDebtReviewStatusDebtCounsellorTelephoneNo,
        'consumerDebtReviewStatusDebtReviewStatusCode' => $consumerDebtReviewStatusDebtReviewStatusCode,
        'consumerDebtReviewStatusHomeTelephoneNo' => $consumerDebtReviewStatusHomeTelephoneNo,
        'consumerDebtReviewStatusWorkTelephoneNo' => $consumerDebtReviewStatusWorkTelephoneNo,
        'consumerDebtReviewStatusCellularNo' => $consumerDebtReviewStatusCellularNo,
        'consumerDebtReviewStatusDebtReviewStatus' => $consumerDebtReviewStatusDebtReviewStatus,
        'consumerDebtReviewStatusDebtCounsellorRegistrationNo' => $consumerDebtReviewStatusDebtCounsellorRegistrationNo,


        'consumerJudgementDisplayText' => $consumerJudgementDisplayText,
        'consumerJudgementCaseFilingDate' => $consumerJudgementCaseFilingDate,
        'consumerJudgementCaseType' => $consumerJudgementCaseType,
        'consumerJudgementLastUpdatedDate' => $consumerJudgementLastUpdatedDate,
        'consumerJudgementPlaintiffName' => $consumerJudgementPlaintiffName,
        'consumerJudgementDisputeAmt' => $consumerJudgementDisputeAmt,
        'consumerJudgementCaseReason' => $consumerJudgementCaseReason,
        'consumerJudgementCourtName' => $consumerJudgementCourtName,
        'consumerJudgementCaseNumber' => $consumerJudgementCaseNumber,
        'consumerJudgementAttorneyName' => $consumerJudgementAttorneyName,
        'consumerJudgementTelephoneNo' => $consumerJudgementTelephoneNo,
        'consumerJudgementComments' => $consumerJudgementComments,

        'consumerAdminOrderDisplayText' => $consumerAdminOrderDisplayText,
        'consumerAdminOrderCaseFilingDate' => $consumerAdminOrderCaseFilingDate,
        'consumerAdminOrderCaseType' => $consumerAdminOrderCaseType,
        'consumerAdminOrderLastUpdatedDate' => $consumerAdminOrderLastUpdatedDate,
        'consumerAdminOrderPlaintiffName' => $consumerAdminOrderPlaintiffName,
        'consumerAdminOrderDisputeAmt' => $consumerAdminOrderDisputeAmt,
        'consumerAdminOrderCaseReason' => $consumerAdminOrderCaseReason,
        'consumerAdminOrderCourtName' => $consumerAdminOrderCourtName,
        'consumerAdminOrderCaseNumber' => $consumerAdminOrderCaseNumber,
        'consumerAdminOrderAttorneyName' => $consumerAdminOrderAttorneyName,
        'consumerAdminOrderTelephoneNo' => $consumerAdminOrderTelephoneNo,
        'consumerAdminOrderComments' => $consumerAdminOrderComments,

        'consumerSequestrationDisplayText' => $consumerSequestrationDisplayText,
        'consumerSequestrationCaseFilingDate' => $consumerSequestrationCaseFilingDate,
        'consumerSequestrationCaseType' => $consumerSequestrationCaseType,
        'consumerSequestrationLastUpdatedDate' => $consumerSequestrationLastUpdatedDate,
        'consumerSequestrationPlaintiffName' => $consumerSequestrationPlaintiffName,
        'consumerSequestrationDisputeAmt' => $consumerSequestrationDisputeAmt,
        'consumerSequestrationCaseReason' => $consumerSequestrationCaseReason,
        'consumerSequestrationCourtName' => $consumerSequestrationCourtName,
        'consumerSequestrationCaseNumber' => $consumerSequestrationCaseNumber,
        'consumerSequestrationAttorneyName' => $consumerSequestrationAttorneyName,
        'consumerSequestrationTelephoneNo' => $consumerSequestrationTelephoneNo,
        'consumerSequestrationComments' => $consumerSequestrationComments,

        'consumerEmailHistoryDisplayText' => $consumerEmailHistoryDisplayText,
        'consumerEmailHistoryEmailAddress' => $consumerEmailHistoryEmailAddress,
        'consumerEmailHistoryLastUpdatedDate' => $consumerEmailHistoryLastUpdatedDate,

        'consumerEmploymentHistoryDisplayText' => $consumerEmploymentHistoryDisplayText,
        'consumerEmploymentHistoryEmployerDetail' => $consumerEmploymentHistoryEmployerDetail,
        'consumerEmploymentHistoryDesignation' => $consumerEmploymentHistoryDesignation,
        'consumerEmploymentHistoryLastUpdatedDate' => $consumerEmploymentHistoryLastUpdatedDate,
        'consumerEmploymentHistoryFirstReportedDate' => $consumerEmploymentHistoryFirstReportedDate,


        'consumerTelephoneHistoryDisplayText' => $consumerTelephoneHistoryDisplayText,
        'consumerTelephoneHistoryConsumerTelephoneID' => $consumerTelephoneHistoryConsumerTelephoneID,
        'consumerTelephoneHistoryTelephoneType' => $consumerTelephoneHistoryTelephoneType,
        'consumerTelephoneHistoryTelephoneTypeInd' => $consumerTelephoneHistoryTelephoneTypeInd,
        'consumerTelephoneHistoryTelCode' => $consumerTelephoneHistoryTelCode,
        'consumerTelephoneHistoryTelephoneNo' => $consumerTelephoneHistoryTelephoneNo,
        'consumerTelephoneHistoryEmailAddress' => $consumerTelephoneHistoryEmailAddress,
        'consumerTelephoneHistoryLastUpdatedDate' => $consumerTelephoneHistoryLastUpdatedDate,
        'consumerTelephoneHistoryFirstReportedDate' => $consumerTelephoneHistoryFirstReportedDate,


        'consumerAddressHistoryDisplayText' => $consumerAddressHistoryDisplayText,
        'consumerAddressHistoryConsumerAddressID' => $consumerAddressHistoryConsumerAddressID,
        'consumerAddressHistoryAddressType' => $consumerAddressHistoryAddressType,
        'consumerAddressHistoryAddressTypeInd' => $consumerAddressHistoryAddressTypeInd,
        'consumerAddressHistoryAddress1' => $consumerAddressHistoryAddress1,
        'consumerAddressHistoryAddress2' => $consumerAddressHistoryAddress2,
        'consumerAddressHistoryAddress3' => $consumerAddressHistoryAddress3,
        'consumerAddressHistoryAddress4' => $consumerAddressHistoryAddress4,
        'consumerAddressHistoryPostalCode' => $consumerAddressHistoryPostalCode,
        'consumerAddressHistoryAddress' => $consumerAddressHistoryAddress,
        'consumerAddressHistoryLastUpdatedDate' => $consumerAddressHistoryLastUpdatedDate,
        'consumerAddressHistoryFirstReportedDate' => $consumerAddressHistoryFirstReportedDate,

        'consumerEnquiryHistoryDisplayText' => $consumerEnquiryHistoryDisplayText,
        'consumerEnquiryHistoryEnquiryDate' => $consumerEnquiryHistoryEnquiryDate,
        'consumerEnquiryHistorySubscriberName' => $consumerEnquiryHistorySubscriberName,
        'consumerEnquiryHistorySubscriberBusinessTypeDesc' => $consumerEnquiryHistorySubscriberBusinessTypeDesc,
        'consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc' => $consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc,
        'consumerEnquiryHistorySubscriberContact' => $consumerEnquiryHistorySubscriberContact,

        'reportId' => $reportId,
        'reportName' => $reportName,

        'consumerDirectorShipLinkDisplayText' => $consumerDirectorShipLinkDisplayText,
        'consumerDirectorShipLinkDirectorDesignationDesc' => $consumerDirectorShipLinkDirectorDesignationDesc,
        'consumerDirectorShipLinkAppointmentDate' => $consumerDirectorShipLinkAppointmentDate,
        'consumerDirectorShipLinkCommercialName' => $consumerDirectorShipLinkCommercialName,
        'consumerDirectorShipLinkRegistrationNo' => $consumerDirectorShipLinkRegistrationNo,
        'consumerDirectorShipLinkPhysicalAddress' => $consumerDirectorShipLinkPhysicalAddress,
        'consumerDirectorShipLinkTelephoneNo' => $consumerDirectorShipLinkTelephoneNo,
        'consumerDirectorShipLinkSICDesc' => $consumerDirectorShipLinkSICDesc,
        'consumerDirectorShipLinkDirectorStatus' => $consumerDirectorShipLinkDirectorStatus
    ]);


    return $pdf->stream('Koketso');
});








Route::get('report-download2', function() {

    define("DOMPDF_ENABLE_PHP", true);

    //assign values to variables
    $strUser = "Statusdata_uat";
    $strPwd = "93eb1864";

    //assign values to variables
    $strUser = "Statusdata_uat";
    $strPwd = "93eb1864";

    $client = new SoapClient ("https://www.uat.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters = array ("strUser"=>$strUser, "strPwd"=>$strPwd);
    $configQry = $client->Login ($parameters);
    //remove special characters
    $ticket = preg_replace ("~/~", "\\\\", $configQry->LoginResult);

    $ConnectTicket = $ticket;
    $Reg1 = '2015';
    $Reg2 = "046144";
    $Reg3="07";
    $BusinessName ="BOTSE BJA LERATO TRADING AND PROJECTS";
    $VatNo ="";
    $SoleProID ="";
    $YourReference ="";
    $VoucherCode ="";

    $client = new SoapClient ("https://www.web.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters = array (
        'ConnectTicket'=>$ConnectTicket,'Reg1'=>$Reg1,'Reg2'=>$Reg2,'Reg3'=>$Reg3,'BusinessName'=>$BusinessName,'VatNo'=>$VatNo,'SolePropIDNo'=>$SoleProID,'YourReference'=>$YourReference);
    $configQry = $client->ConnectBusinessMatch($parameters);


    $EnquiryID = $myArray2[4];
    $EnquiryResultID = $myArray[1];
    $ProductID='15';
    $BonusXML ='';
    $client = new SoapClient ("https://www.web.xds.co.za/xdsconnect/XDSConnectWS.asmx?WSDL");
    $parameters=array("ConnectTicket"=>$ConnectTicket,'EnquiryID'=>$EnquiryID,'EnquiryResultID'=>$EnquiryResultID,'ProductID'=>$ProductID,'BonusXML'=>$BonusXML);
    $configQry2 = $client->ConnectGetResult($parameters);

    $result2 = $configQry2->ConnectGetResultResult;
    $loadResult2 = simplexml_load_string($result2);

    //Report
    $reportId = $loadResult2->ReportInformation->ReportID;
    $reportName = $loadResult2->ReportInformation->ReportName;

    $consumerDisplayText = $loadResult2->ConsumerDirectorSummary->DisplayText;
    $NumberOfCompanyDirector = $loadResult2->ConsumerDirectorSummary->NumberOfCompanyDirector;

    //ConsumerJudgement - list

    $consumerJudgementDisplayText = $loadResult2->ConsumerJudgement->Displaytext;
    $consumerJudgementCaseFilingDate = $loadResult2->ConsumerJudgement->CaseFilingDate;
    $consumerJudgementCaseType = $loadResult2->ConsumerJudgement->CaseType;
    $consumerJudgementLastUpdatedDate = $loadResult2->ConsumerJudgement->LastUpdatedDate;
    $consumerJudgementPlaintiffName = $loadResult2->ConsumerJudgement->PlaintiffName;
    $consumerJudgementDisputeAmt = $loadResult2->ConsumerJudgement->DisputeAmt;
    $consumerJudgementCaseReason = $loadResult2->ConsumerJudgement->CaseReason;
    $consumerJudgementCourtName = $loadResult2->ConsumerJudgement->CourtName;
    $consumerJudgementCaseNumber = $loadResult2->ConsumerJudgement->CaseNumber;
    $consumerJudgementAttorneyName = $loadResult2->ConsumerJudgement->AttorneyName;
    $consumerJudgementTelephoneNo = $loadResult2->ConsumerJudgement->TelephoneNo;
    $consumerJudgementComments = $loadResult2->ConsumerJudgement->Comments;

    //ConsumerAdminOrder

    $consumerAdminOrderDisplayText = $loadResult2->ConsumerAdminOrder->DisplayText;
    $consumerAdminOrderCaseFilingDate = $loadResult2->ConsumerAdminOrder->CaseFilingDate;
    $consumerAdminOrderCaseType = $loadResult2->ConsumerAdminOrder->CaseType;
    $consumerAdminOrderLastUpdatedDate = $loadResult2->ConsumerAdminOrder->LastUpdatedDate;
    $consumerAdminOrderPlaintiffName = $loadResult2->ConsumerAdminOrder->PlaintiffName;
    $consumerAdminOrderDisputeAmt = $loadResult2->ConsumerAdminOrder->DisputeAmt;
    $consumerAdminOrderCaseReason = $loadResult2->ConsumerAdminOrder->CaseReason;
    $consumerAdminOrderCourtName = $loadResult2->ConsumerAdminOrder->CourtName;
    $consumerAdminOrderCaseNumber = $loadResult2->ConsumerAdminOrder->CaseNumber;
    $consumerAdminOrderAttorneyName = $loadResult2->ConsumerAdminOrder->AttorneyName;
    $consumerAdminOrderTelephoneNo = $loadResult2->ConsumerAdminOrder->TelephoneNo;
    $consumerAdminOrderComments = $loadResult2->ConsumerAdminOrder->Comments;

    //ConsumerSequestration

    $consumerSequestrationDisplayText = $loadResult2->ConsumerSequestration->DisplayText;
    $consumerSequestrationCaseFilingDate = $loadResult2->ConsumerSequestration->CaseFilingDate;
    $consumerSequestrationCaseType = $loadResult2->ConsumerSequestration->CaseType;
    $consumerSequestrationLastUpdatedDate = $loadResult2->ConsumerSequestration->LastUpdatedDate;
    $consumerSequestrationPlaintiffName = $loadResult2->ConsumerSequestration->PlaintiffName;
    $consumerSequestrationDisputeAmt = $loadResult2->ConsumerSequestration->DisputeAmt;
    $consumerSequestrationCaseReason = $loadResult2->ConsumerSequestration->CaseReason;
    $consumerSequestrationCourtName = $loadResult2->ConsumerSequestration->CourtName;
    $consumerSequestrationCaseNumber = $loadResult2->ConsumerSequestration->CaseNumber;
    $consumerSequestrationAttorneyName = $loadResult2->ConsumerSequestration->AttorneyName;
    $consumerSequestrationTelephoneNo = $loadResult2->ConsumerSequestration->TelephoneNo;
    $consumerSequestrationComments = $loadResult2->ConsumerSequestration->Comments;

    //ConsumerEnquiryHistory - list

    $consumerEnquiryHistoryDisplayText = $loadResult2->ConsumerEnquiryHistory->DisplayText;
    $consumerEnquiryHistoryEnquiryDate = $loadResult2->ConsumerEnquiryHistory->EnquiryDate;
    $consumerEnquiryHistorySubscriberName = $loadResult2->ConsumerEnquiryHistory->SubscriberName;
    $consumerEnquiryHistorySubscriberBusinessTypeDesc = $loadResult2->ConsumerEnquiryHistory->SubscriberBusinessTypeDesc;
    $consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc = $loadResult2->ConsumerEnquiryHistory->CreditGrantorEnquiryReasonDesc;
    $consumerEnquiryHistorySubscriberContact = $loadResult2->ConsumerEnquiryHistory->SubscriberContact;

    //ConsumerDebtReviewStatus

    $consumerDebtReviewStatusDisplayText = $loadResult2->ConsumerDebtReviewStatus->DisplayText;
    $consumerDebtReviewStatusIDno = $loadResult2->ConsumerDebtReviewStatus->IDno;
    $consumerDebtReviewStatusFirstName = $loadResult2->ConsumerDebtReviewStatus->FirstName;
    $consumerDebtReviewStatusSurName = $loadResult2->ConsumerDebtReviewStatus->SurName;
    $consumerDebtReviewStatusBirthDate = $loadResult2->ConsumerDebtReviewStatus->BirthDate;
    $consumerDebtReviewStatusDebtReviewStatusDate = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatusDate;
    $consumerDebtReviewStatusDebtCounsellorName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorName;
    $consumerDebtReviewStatusDebtCounsellorFirstName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorFirstName;
    $consumerDebtReviewStatusDebtCounsellorSurName = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorSurName;
    $consumerDebtReviewStatusDebtCounsellorTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorTelephoneNo;
    $consumerDebtReviewStatusDebtReviewStatusCode = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatusCode;
    $consumerDebtReviewStatusHomeTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->HomeTelephoneNo;
    $consumerDebtReviewStatusWorkTelephoneNo = $loadResult2->ConsumerDebtReviewStatus->WorkTelephoneNo;
    $consumerDebtReviewStatusCellularNo = $loadResult2->ConsumerDebtReviewStatus->CellularNo;
    $consumerDebtReviewStatusDebtReviewStatus = $loadResult2->ConsumerDebtReviewStatus->DebtReviewStatus;
    $consumerDebtReviewStatusDebtCounsellorRegistrationNo = $loadResult2->ConsumerDebtReviewStatus->DebtCounsellorRegistrationNo;

    //ConsumerDirectorShipLink - list

    $consumerDirectorShipLinkDisplayText = $loadResult2->ConsumerDirectorShipLink->DisplayText;
    $consumerDirectorShipLinkDirectorDesignationDesc = $loadResult2->ConsumerDirectorShipLink->DirectorDesignationDesc;
    $consumerDirectorShipLinkAppointmentDate = $loadResult2->ConsumerDirectorShipLink->AppointmentDate;
    $consumerDirectorShipLinkCommercialName = $loadResult2->ConsumerDirectorShipLink->CommercialName;
    $consumerDirectorShipLinkRegistrationNo = $loadResult2->ConsumerDirectorShipLink->RegistrationNo;
    $consumerDirectorShipLinkPhysicalAddress = $loadResult2->ConsumerDirectorShipLink->PhysicalAddress;
    $consumerDirectorShipLinkTelephoneNo =$loadResult2->ConsumerDirectorShipLink->TelephoneNo;
    $consumerDirectorShipLinkSICDesc = $loadResult2->ConsumerDirectorShipLink->SICDesc;
    $consumerDirectorShipLinkDirectorStatus = $loadResult2->ConsumerDirectorShipLink->DirectorStatus;

    //ConsumerPropertyInformation

    $consumerPropertyInformationDisplayText = $loadResult2->ConsumerPropertyInformation->DisplayText;
    $consumerPropertyInformationAuthorityName = $loadResult2->ConsumerPropertyInformation->AuthorityName;
    $consumerPropertyInformationTownshipName = $loadResult2->ConsumerPropertyInformation->TownshipName;
    $consumerPropertyInformationStandNo = $loadResult2->ConsumerPropertyInformation->StandNo;/*
        PortionNo = PortionNo;
        TitleDeedNo = TitleDeedNo;
        BuyerName = BuyerName;
        BuyerTypeCode = BuyerTypeCode;
        BuyerIDNo = BuyerIDNo;
        BuyerMaritalStatusCode = BuyerMaritalStatusCode;
        SellerName = SellerName;
        SellerTypeCode = SellerTypeCode;
        SellerIDNo = SellerIDNo;
        SellerMaritalStatusCode = SellerMaritalStatusCode;
        TransferDate = TransferDate;
        RegistrarName = RegistrarName;
        OldTitleDeedNo = OldTitleDeedNo;
        AttorneyFirmNo = AttorneyFirmNo;
        AttorneyFileNo = AttorneyFileNo;
        TitleDeedFeeAmt = TitleDeedFeeAmt;
        PropertyTypeCode = PropertyTypeCode;
        StreetNo = StreetNo;
        StreetName = StreetName;
        SuburbName = SuburbName; */

    //ConsumerAddressHistory - list

    $consumerAddressHistoryDisplayText = $loadResult2->ConsumerAddressHistory->DisplayText;
    $consumerAddressHistoryConsumerAddressID = $loadResult2->ConsumerAddressHistory->ConsumerAddressID;
    $consumerAddressHistoryAddressType = $loadResult2->ConsumerAddressHistory->AddressType;
    $consumerAddressHistoryAddressTypeInd = $loadResult2->ConsumerAddressHistory->AddressTypeInd;
    $consumerAddressHistoryAddress1 = $loadResult2->ConsumerAddressHistory->Address1;
    $consumerAddressHistoryAddress2 = $loadResult2->ConsumerAddressHistory->Address2;
    $consumerAddressHistoryAddress3 = $loadResult2->ConsumerAddressHistory->Address3;
    $consumerAddressHistoryAddress4 = $loadResult2->ConsumerAddressHistory->Address4;
    $consumerAddressHistoryPostalCode = $loadResult2->ConsumerAddressHistory->PostalCode;
    $consumerAddressHistoryAddress =$loadResult2->ConsumerAddressHistory-> Address;
    $consumerAddressHistoryLastUpdatedDate = $loadResult2->ConsumerAddressHistory->LastUpdatedDate;
    $consumerAddressHistoryFirstReportedDate = $loadResult2->ConsumerAddressHistory->FirstReportedDate;

    //ConsumerTelephoneHistory - list

    $consumerTelephoneHistoryDisplayText = $loadResult2->ConsumerTelephoneHistory->DisplayText;
    $consumerTelephoneHistoryConsumerTelephoneID = $loadResult2->ConsumerTelephoneHistory->ConsumerTelephoneID;
    $consumerTelephoneHistoryTelephoneType = $loadResult2->ConsumerTelephoneHistory->TelephoneType;
    $consumerTelephoneHistoryTelephoneTypeInd = $loadResult2->ConsumerTelephoneHistory->TelephoneTypeInd;
    $consumerTelephoneHistoryTelCode =$loadResult2->ConsumerTelephoneHistory->TelCode;
    $consumerTelephoneHistoryTelephoneNo = $loadResult2->ConsumerTelephoneHistory->TelephoneNo;
    $consumerTelephoneHistoryEmailAddress = $loadResult2->ConsumerTelephoneHistory->EmailAddress;
    $consumerTelephoneHistoryLastUpdatedDate = $loadResult2->ConsumerTelephoneHistory->LastUpdatedDate;
    $consumerTelephoneHistoryFirstReportedDate = $loadResult2->ConsumerTelephoneHistory->FirstReportedDate;

    //ConsumerEmploymentHistory
    $consumerEmploymentHistoryDisplayText = $loadResult2->ConsumerEmploymentHistory->DisplayText;
    $consumerEmploymentHistoryEmployerDetail = $loadResult2->ConsumerEmploymentHistory->EmployerDetail;
    $consumerEmploymentHistoryDesignation = $loadResult2->ConsumerEmploymentHistory->Designation;
    $consumerEmploymentHistoryLastUpdatedDate = $loadResult2->ConsumerEmploymentHistory->LastUpdatedDate;
    $consumerEmploymentHistoryFirstReportedDate = $loadResult2->ConsumerEmploymentHistory->FirstReportedDate;

    //ConsumerDetail
    $consumerDetailDisplayText = $loadResult2->ConsumerDetail->DisplayText;
    $consumerDetailConsumerID = $loadResult2->ConsumerDetail->ConsumerID;
    $consumerDetailInitials = $loadResult2->ConsumerDetail->Initials;
    $consumerDetailFirstName = $loadResult2->ConsumerDetail->FirstName;
    $consumerDetailSecondName = $loadResult2->ConsumerDetail->SecondName;
    $consumerDetailThirdName = $loadResult2->ConsumerDetail->ThirdName;
    $consumerDetailSurname = $loadResult2->ConsumerDetail->Surname;
    $consumerDetailMaidenName =$loadResult2->ConsumerDetail->MaidenName;
    $consumerDetailIDNo = $loadResult2->ConsumerDetail->IDNo;
    $consumerDetailPassportNo =$loadResult2->ConsumerDetail->PassportNo;
    $consumerDetailBirthDate = $loadResult2->ConsumerDetail->BirthDate;
    $consumerDetailGender =$loadResult2->ConsumerDetail->Gender;
    $consumerDetailTitleDesc =$loadResult2->ConsumerDetail->TitleDesc;
    $consumerDetailMaritalStatusDesc =$loadResult2->ConsumerDetail->MaritalStatusDesc;
    $consumerDetailPrivacyStatus =$loadResult2->ConsumerDetail->PrivacyStatus;
    $consumerDetailResidentialAddress =$loadResult2->ConsumerDetail->ResidentialAddress;
    $consumerDetailPostalAddress =$loadResult2->ConsumerDetail->PostalAddress ;
    $consumerDetailHomeTelephoneNo =$loadResult2->ConsumerDetail->HomeTelephoneNo;
    $consumerDetailWorkTelephoneNo = $loadResult2->ConsumerDetail->WorkTelephoneNo;
    $consumerDetailCellularNo =$loadResult2->ConsumerDetail->CellularNo;
    $consumerDetailEmailAddress = $loadResult2->ConsumerDetail->EmailAddress;
    $consumerDetailEmployerDetail = $loadResult2->ConsumerDetail->EmployerDetail;
    $consumerDetailReferenceNo = $loadResult2->ConsumerDetail->ReferenceNo;
    $consumerDetailExternalReference = $loadResult2->ConsumerDetail->ExternalReference;

    //ConsumerFraudIndicatorsSummary
    $consumerFraudIndicatorsSummaryDisplayText = $loadResult2->ConsumerFraudIndicatorsSummary->DisplayText;
    $consumerFraudIndicatorsSummarySAFPSListingYN = $loadResult2->ConsumerFraudIndicatorsSummary->SAFPSListingYN;
    $consumerFraudIndicatorsSummaryHomeAffairsVerificationYN = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsVerificationYN;
    $consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsDeceasedStatus;
    $consumerFraudIndicatorsSummaryEmployerFraudVerificationYN = $loadResult2->ConsumerFraudIndicatorsSummary->EmployerFraudVerificationYN;
    $consumerFraudIndicatorsSummaryProtectiveVerificationYN =$loadResult2->ConsumerFraudIndicatorsSummary->ProtectiveVerificationYN;
    $consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate = $loadResult2->ConsumerFraudIndicatorsSummary->HomeAffairsDeceasedDate;


    //ConsumerPropertyInformationSummary

    $consumerPropertyInformationSummaryDisplayText = $loadResult2->ConsumerPropertyInformationSummary->DisplayText;
    $consumerPropertyInformationSummaryTotalProperty = $loadResult2->ConsumerPropertyInformationSummary->TotalProperty;
    $consumerPropertyInformationSummaryPurchasePrice = $loadResult2->ConsumerPropertyInformationSummary->PurchasePrice;


    //ConsumerEmailHistory - list

    $consumerEmailHistoryDisplayText = $loadResult2->ConsumerEmailHistory->DisplayText;
    $consumerEmailHistoryEmailAddress = $loadResult2->ConsumerEmailHistory->EmailAddress;
    $consumerEmailHistoryLastUpdatedDate = $loadResult2->ConsumerEmailHistory->LastUpdatedDate;

    $pdf = \PDF::loadView('pdf.xdsConsumerReport', [
        'loadResult2' => $loadResult2,
        'consumerDetailDisplayText' => $consumerDetailDisplayText,
        'consumerDetailConsumerID' => $consumerDetailConsumerID,
        'consumerDetailInitials' => $consumerDetailInitials,
        'consumerDetailFirstName' => $consumerDetailFirstName,
        'consumerDetailSecondName' => $consumerDetailSecondName,
        'consumerDetailThirdName' => $consumerDetailThirdName,
        'consumerDetailSurname' => $consumerDetailSurname,
        'consumerDetailMaidenName' => $consumerDetailMaidenName,
        'consumerDetailIDNo' => $consumerDetailIDNo,
        'consumerDetailPassportNo' => $consumerDetailPassportNo,
        'consumerDetailBirthDate' => $consumerDetailBirthDate,
        'consumerDetailGender' => $consumerDetailGender,
        'consumerDetailTitleDesc' => $consumerDetailTitleDesc,
        'consumerDetailMaritalStatusDesc' => $consumerDetailMaritalStatusDesc,
        'consumerDetailPrivacyStatus' => $consumerDetailPrivacyStatus,
        'consumerDetailResidentialAddress' => $consumerDetailResidentialAddress,
        'consumerDetailPostalAddress' => $consumerDetailPostalAddress,
        'consumerDetailHomeTelephoneNo' => $consumerDetailHomeTelephoneNo,
        'consumerDetailWorkTelephoneNo' => $consumerDetailWorkTelephoneNo,
        'consumerDetailCellularNo' => $consumerDetailCellularNo,
        'consumerDetailEmailAddress' => $consumerDetailEmailAddress,
        'consumerDetailEmployerDetail' => $consumerDetailEmployerDetail,
        'consumerDetailReferenceNo' => $consumerDetailReferenceNo,
        'consumerDetailExternalReference' => $consumerDetailExternalReference,

        'consumerPropertyInformationSummaryDisplayText' => $consumerPropertyInformationSummaryDisplayText,
        'consumerPropertyInformationSummaryTotalProperty' => $consumerPropertyInformationSummaryTotalProperty,
        'consumerPropertyInformationSummaryPurchasePrice' => $consumerPropertyInformationSummaryPurchasePrice,

        'consumerFraudIndicatorsSummaryDisplayText' => $consumerFraudIndicatorsSummaryDisplayText,
        'consumerFraudIndicatorsSummarySAFPSListingYN' => $consumerFraudIndicatorsSummarySAFPSListingYN,
        'consumerFraudIndicatorsSummaryHomeAffairsVerificationYN' => $consumerFraudIndicatorsSummaryHomeAffairsVerificationYN,
        'consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus' => $consumerFraudIndicatorsSummaryHomeAffairsDeceasedStatus,
        'consumerFraudIndicatorsSummaryEmployerFraudVerificationYN' => $consumerFraudIndicatorsSummaryEmployerFraudVerificationYN,
        'consumerFraudIndicatorsSummaryProtectiveVerificationYN' => $consumerFraudIndicatorsSummaryProtectiveVerificationYN,
        'consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate' => $consumerFraudIndicatorsSummaryHomeAffairsDeceasedDate,

        'consumerDebtReviewStatusDisplayText' => $consumerDebtReviewStatusDisplayText,
        'consumerDebtReviewStatusFirstName' => $consumerDebtReviewStatusFirstName,
        'consumerDebtReviewStatusSurName' => $consumerDebtReviewStatusSurName,
        'consumerDebtReviewStatusBirthDate' => $consumerDebtReviewStatusBirthDate,
        'consumerDebtReviewStatusDebtReviewStatusDate' => $consumerDebtReviewStatusDebtReviewStatusDate,
        'consumerDebtReviewStatusDebtCounsellorName' => $consumerDebtReviewStatusDebtCounsellorName,
        'consumerDebtReviewStatusDebtCounsellorFirstName' => $consumerDebtReviewStatusDebtCounsellorFirstName,
        'consumerDebtReviewStatusDebtCounsellorSurName' => $consumerDebtReviewStatusDebtCounsellorSurName,
        'consumerDebtReviewStatusDebtCounsellorTelephoneNo' => $consumerDebtReviewStatusDebtCounsellorTelephoneNo,
        'consumerDebtReviewStatusDebtReviewStatusCode' => $consumerDebtReviewStatusDebtReviewStatusCode,
        'consumerDebtReviewStatusHomeTelephoneNo' => $consumerDebtReviewStatusHomeTelephoneNo,
        'consumerDebtReviewStatusWorkTelephoneNo' => $consumerDebtReviewStatusWorkTelephoneNo,
        'consumerDebtReviewStatusCellularNo' => $consumerDebtReviewStatusCellularNo,
        'consumerDebtReviewStatusDebtReviewStatus' => $consumerDebtReviewStatusDebtReviewStatus,
        'consumerDebtReviewStatusDebtCounsellorRegistrationNo' => $consumerDebtReviewStatusDebtCounsellorRegistrationNo,


        'consumerJudgementDisplayText' => $consumerJudgementDisplayText,
        'consumerJudgementCaseFilingDate' => $consumerJudgementCaseFilingDate,
        'consumerJudgementCaseType' => $consumerJudgementCaseType,
        'consumerJudgementLastUpdatedDate' => $consumerJudgementLastUpdatedDate,
        'consumerJudgementPlaintiffName' => $consumerJudgementPlaintiffName,
        'consumerJudgementDisputeAmt' => $consumerJudgementDisputeAmt,
        'consumerJudgementCaseReason' => $consumerJudgementCaseReason,
        'consumerJudgementCourtName' => $consumerJudgementCourtName,
        'consumerJudgementCaseNumber' => $consumerJudgementCaseNumber,
        'consumerJudgementAttorneyName' => $consumerJudgementAttorneyName,
        'consumerJudgementTelephoneNo' => $consumerJudgementTelephoneNo,
        'consumerJudgementComments' => $consumerJudgementComments,

        'consumerAdminOrderDisplayText' => $consumerAdminOrderDisplayText,
        'consumerAdminOrderCaseFilingDate' => $consumerAdminOrderCaseFilingDate,
        'consumerAdminOrderCaseType' => $consumerAdminOrderCaseType,
        'consumerAdminOrderLastUpdatedDate' => $consumerAdminOrderLastUpdatedDate,
        'consumerAdminOrderPlaintiffName' => $consumerAdminOrderPlaintiffName,
        'consumerAdminOrderDisputeAmt' => $consumerAdminOrderDisputeAmt,
        'consumerAdminOrderCaseReason' => $consumerAdminOrderCaseReason,
        'consumerAdminOrderCourtName' => $consumerAdminOrderCourtName,
        'consumerAdminOrderCaseNumber' => $consumerAdminOrderCaseNumber,
        'consumerAdminOrderAttorneyName' => $consumerAdminOrderAttorneyName,
        'consumerAdminOrderTelephoneNo' => $consumerAdminOrderTelephoneNo,
        'consumerAdminOrderComments' => $consumerAdminOrderComments,

        'consumerSequestrationDisplayText' => $consumerSequestrationDisplayText,
        'consumerSequestrationCaseFilingDate' => $consumerSequestrationCaseFilingDate,
        'consumerSequestrationCaseType' => $consumerSequestrationCaseType,
        'consumerSequestrationLastUpdatedDate' => $consumerSequestrationLastUpdatedDate,
        'consumerSequestrationPlaintiffName' => $consumerSequestrationPlaintiffName,
        'consumerSequestrationDisputeAmt' => $consumerSequestrationDisputeAmt,
        'consumerSequestrationCaseReason' => $consumerSequestrationCaseReason,
        'consumerSequestrationCourtName' => $consumerSequestrationCourtName,
        'consumerSequestrationCaseNumber' => $consumerSequestrationCaseNumber,
        'consumerSequestrationAttorneyName' => $consumerSequestrationAttorneyName,
        'consumerSequestrationTelephoneNo' => $consumerSequestrationTelephoneNo,
        'consumerSequestrationComments' => $consumerSequestrationComments,

        'consumerEmailHistoryDisplayText' => $consumerEmailHistoryDisplayText,
        'consumerEmailHistoryEmailAddress' => $consumerEmailHistoryEmailAddress,
        'consumerEmailHistoryLastUpdatedDate' => $consumerEmailHistoryLastUpdatedDate,

        'consumerEmploymentHistoryDisplayText' => $consumerEmploymentHistoryDisplayText,
        'consumerEmploymentHistoryEmployerDetail' => $consumerEmploymentHistoryEmployerDetail,
        'consumerEmploymentHistoryDesignation' => $consumerEmploymentHistoryDesignation,
        'consumerEmploymentHistoryLastUpdatedDate' => $consumerEmploymentHistoryLastUpdatedDate,
        'consumerEmploymentHistoryFirstReportedDate' => $consumerEmploymentHistoryFirstReportedDate,


        'consumerTelephoneHistoryDisplayText' => $consumerTelephoneHistoryDisplayText,
        'consumerTelephoneHistoryConsumerTelephoneID' => $consumerTelephoneHistoryConsumerTelephoneID,
        'consumerTelephoneHistoryTelephoneType' => $consumerTelephoneHistoryTelephoneType,
        'consumerTelephoneHistoryTelephoneTypeInd' => $consumerTelephoneHistoryTelephoneTypeInd,
        'consumerTelephoneHistoryTelCode' => $consumerTelephoneHistoryTelCode,
        'consumerTelephoneHistoryTelephoneNo' => $consumerTelephoneHistoryTelephoneNo,
        'consumerTelephoneHistoryEmailAddress' => $consumerTelephoneHistoryEmailAddress,
        'consumerTelephoneHistoryLastUpdatedDate' => $consumerTelephoneHistoryLastUpdatedDate,
        'consumerTelephoneHistoryFirstReportedDate' => $consumerTelephoneHistoryFirstReportedDate,


        'consumerAddressHistoryDisplayText' => $consumerAddressHistoryDisplayText,
        'consumerAddressHistoryConsumerAddressID' => $consumerAddressHistoryConsumerAddressID,
        'consumerAddressHistoryAddressType' => $consumerAddressHistoryAddressType,
        'consumerAddressHistoryAddressTypeInd' => $consumerAddressHistoryAddressTypeInd,
        'consumerAddressHistoryAddress1' => $consumerAddressHistoryAddress1,
        'consumerAddressHistoryAddress2' => $consumerAddressHistoryAddress2,
        'consumerAddressHistoryAddress3' => $consumerAddressHistoryAddress3,
        'consumerAddressHistoryAddress4' => $consumerAddressHistoryAddress4,
        'consumerAddressHistoryPostalCode' => $consumerAddressHistoryPostalCode,
        'consumerAddressHistoryAddress' => $consumerAddressHistoryAddress,
        'consumerAddressHistoryLastUpdatedDate' => $consumerAddressHistoryLastUpdatedDate,
        'consumerAddressHistoryFirstReportedDate' => $consumerAddressHistoryFirstReportedDate,

        'consumerEnquiryHistoryDisplayText' => $consumerEnquiryHistoryDisplayText,
        'consumerEnquiryHistoryEnquiryDate' => $consumerEnquiryHistoryEnquiryDate,
        'consumerEnquiryHistorySubscriberName' => $consumerEnquiryHistorySubscriberName,
        'consumerEnquiryHistorySubscriberBusinessTypeDesc' => $consumerEnquiryHistorySubscriberBusinessTypeDesc,
        'consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc' => $consumerEnquiryHistorySubscriberCreditGrantorEnquiryReasonDesc,
        'consumerEnquiryHistorySubscriberContact' => $consumerEnquiryHistorySubscriberContact,

        'reportId' => $reportId,
        'reportName' => $reportName,

        'consumerDirectorShipLinkDisplayText' => $consumerDirectorShipLinkDisplayText,
        'consumerDirectorShipLinkDirectorDesignationDesc' => $consumerDirectorShipLinkDirectorDesignationDesc,
        'consumerDirectorShipLinkAppointmentDate' => $consumerDirectorShipLinkAppointmentDate,
        'consumerDirectorShipLinkCommercialName' => $consumerDirectorShipLinkCommercialName,
        'consumerDirectorShipLinkRegistrationNo' => $consumerDirectorShipLinkRegistrationNo,
        'consumerDirectorShipLinkPhysicalAddress' => $consumerDirectorShipLinkPhysicalAddress,
        'consumerDirectorShipLinkTelephoneNo' => $consumerDirectorShipLinkTelephoneNo,
        'consumerDirectorShipLinkSICDesc' => $consumerDirectorShipLinkSICDesc,
        'consumerDirectorShipLinkDirectorStatus' => $consumerDirectorShipLinkDirectorStatus
    ]);


    return $pdf->stream('Koketso2');
});







Route::get('invoice-download/{company}', function($company) {

    define("DOMPDF_ENABLE_PHP", true);

    $transactions = DB::table('transactions')
        ->where('company','=',$company)
        ->get();

    $id = DB::table('companies')
        ->where('companyName','=',$company)
        ->first();

    $id = $id->id;

    $total = 0;

    foreach($transactions as $transaction)
    {
        $total = $total + $transaction->price;
    }

    if (count($transactions) < 1) {
        App::abort(404);
    }

    $pdf = \PDF::loadView('pdf.invoice', [
        'transactions' => $transactions,
        'id' => $id,
        'total' => $total,
        'company' => $company
    ]);
    return $pdf->stream('$company');
});



Route::post('BCS-request','PagesController@handleBCS');
Route::post('OFS-request','PagesController@handleOFS');
Route::post('AVSR-request','PagesController@handleAVSR');
Route::post('new-user/{company}','PagesController@CreateNewUser');
Route::post('check-BCS-status','PagesController@checkBCSstatus');
Route::post('support', 'PagesController@handleSupport');
Route::post('quote', 'PagesController@handleInsuranceQuote');
Route::post('query-system','PagesController@handleQuerySystem');
Route::post('debt-collection', 'PagesController@handleDebtCollection');
Route::post('check-BCS-status','PagesController@checkBCSstatus');
Route::post('compuscan-report','PagesController@handlePossibleMatchSearch');
Route::post('full-company-search','PagesController@handleFullCompanySearch');
Route::post('previous-company-search','PagesController@handlePreviousCompanySearch');
Route::post('full-reports','PagesController@handleResearchedReport');
Route::post('collect-AVSR-report','PagesController@handleCollectAVSR');
Route::post('business-commercial-report','PagesController@handleBusinessCommercialReport');
Route::post('business-bank-code','PagesController@handleBusinessBankCode');
Route::post('transunion-bank-code','PagesController@handleTransunionBusinessBankCode');
Route::post('compuscan-principal-express-bank-code','PagesController@handleCompuscanPrincipalExressBankCode');
Route::post('transunion-principal-bank-code','PagesController@handleTransunionPrincipalBankCode');
Route::post('compuscan-express-bank-code','PagesController@handleCompuscanExpressBankCode');
Route::post('transunion-researched-report','PagesController@handleTransunionResearchedReport');
Route::post('individual-bank-code','PagesController@handleIndividualBankCode');
Route::post('individual-report','PagesController@handleIndividualReport');
Route::post('credit-check2','PagesController@handleCreditCheck2');
Route::post('credit-check2BCD','PagesController@handleCreditCheck2BCD');
Route::post('individual-deeds','PagesController@handleIndividualDeeds');
Route::post('business-summary','PagesController@handleBusinessSummary');
Route::post('full-bank-code','PagesController@handleFullBankCode');
Route::post('quick-fix-report','PagesController@handleQuickFixReport');
Route::post('bank-code-commercial','PagesController@handleBankCodeCommercial');
Route::post('principal-bank-code','PagesController@handlePrincipalBankCode');
Route::post('bank-code-commercial-express','PagesController@handleBankCodeCommercialExpress');
Route::post('principal-bank-code-express','PagesController@handlePrincipalBankCodeExpress');

Route::post('status-researched-report','PagesController@handleStatusResearchedReport');
Route::post('express-basic-commercial','PagesController@handleExpressBasicCommercial');
Route::post('express-basic-principal','PagesController@handleExpressBasicPrincipal');
Route::post('basic-commercial','PagesController@handleBasicCommercial');
Route::post('basic-principal','PagesController@handleBasicPrincipal');
Route::post('prestige-support','PagesController@handlePrestigeSupport');

Route::post('detailed-commercial','PagesController@handleDetailedCommercial');

Route::post('detailed-principal','PagesController@handleDetailedPrincipal');
Route::post('compuscan-company-deeds','PagesController@handleCompanyDeeds');
Route::post('banner-image','PagesController@handleBannerPreview');

Route::post('DMS-support','PagesController@handleDMSSupport');
Route::post('banner','PagesController@handleBanner');
Route::post('new-company','PagesController@handleNewCompany');
Route::post('transunion-investigate','PagesController@handleTransunionInvestigate');
Route::post('edit-user/{user}', ['as' => 'users.edit-user', 'uses' => 'PagesController@handleEditUser']);

Route::post('edit-pricing/{name}', ['as' => 'invoice.edit-pricing', 'uses' => 'PagesController@handleEditPricing']);

Route::post('generate-invoice/{id}', ['as' => 'invoice.generate-invoice', 'uses' => 'PagesController@serverHandleGenerateInvoice']);
Route::post('collect-BCS-report', ['as' => 'bank-codes.collect-BCS-report', 'uses' => 'PagesController@checkBCSstatus']);
Route::post('link-user/{id}', ['as' => 'users.link-user', 'uses' => 'PagesController@handleLinkUserMultipleCompanies']);

Route::post('edit-company/{id}', ['as' => 'management.edit-company', 'uses' => 'PagesController@handleEditCompany']);

