<?php

class InoxicoController extends BaseController{

    public function serverInoxicoResearchedReport()
    {
        $email = Auth::user()->email;

        $user = DB::table('users')
            ->where('email','=',$email)
            ->first();

        return View::make('inoxico.inoxico-researched-report')
            ->with('user',$user);
    }

    public function handleInoxicoResearchedReport()
    {
        $validator = Validator::make(Input::all(),
            [
                'contactNumber' => 'required',
                'email' => 'required',
                'accountHolder' => 'required',
                'bankCodeRequest' => 'required',
                'bank' => 'required',
                'enquiryCurrency' => 'required',
                'branch' => 'required',
                'branchName' => 'required',
                'terms' => 'required'
            ]);

        if($validator->fails())
        {
            return Redirect::back()->with('view-error', '<i class="white fa fa-exclamation-triangle"></i> There were errors in your submission please review below')->withInput()->withErrors($validator);
        }

        $inoxico = new Inoxico;
        $inoxico->contactNumber = Input::get('contactNumber');
        $inoxico->email = Input::get('email');
        $inoxico->currency = Input::get('currency');
        $inoxico->consent1 = Input::get('consent1');
        $inoxico->subject = Input::get('subject');
        $inoxico->instructions = Input::get('instructions');
        $inoxico->file1 = Input::get('file1');
        $inoxico->file2 = Input::get('file2');
        $inoxico->file3 = Input::get('file3');
        $inoxico->accountHolder = Input::get('accountHolder');
        $inoxico->bankCodeRequest = Input::get('bankCodeRequest');
        $inoxico->bank = Input::get('bank');
        $inoxico->enquiryCurrency = Input::get('enquiryCurrency');
        $inoxico->branch = Input::get('branch');
        $inoxico->branchName = Input::get('branchName');
        $inoxico->terms = Input::get('terms');

        $inoxico->amount = Input::get('amount');
        $inoxico->accountNumber = Input::get('accountNumber');
        $inoxico->accountType = Input::get('accountType');
        $inoxico->save();

        return Redirect::to('/references/'.$inoxico->id)->with('view-success',' Add trade references.');
    }

    public function serveReferences($id)
    {
        $references = DB::table('inoxicoReferences')
            ->where('referenceId','=',$id)
            ->get();

        $email = Auth::user()->email;

        $user = DB::table('users')
            ->where('email','=',$email)
            ->first();

        return View::make('inoxico.references')
            ->with('id',$id)
            ->with('user',$user)
            ->with('references',$references);
    }

    public function handleReferences($id)
    {
        $validator = Validator::make(Input::all(),
            [
                'name' => 'required',
                'email' => 'required',
                'number' => 'required'
            ]);

        if($validator->fails())
        {
            return Redirect::back()->with('view-error', '<i class="white fa fa-exclamation-triangle"></i> There were errors in your submission please review below')->withInput()->withErrors($validator);
        }

        $reference = new InoxicoReference;
        $reference->name = Input::get('name');
        $reference->email = Input::get('email');
        $reference->number = Input::get('number');
        $reference->referenceId = $id;
        $reference->save();


        return Redirect::back()->with('view-success',' Add another reference or proceed to submit your request.');

    }

    public function submitInoxicoResearchedReport($id)
    {
        $inoxico = DB::table('inoxicos')
            ->where('id', '=', $id)
            ->first();

        $references = DB::table('inoxicoReferences')
            ->where('referenceId','=',$id)
            ->get();

        $data = ['inoxico' => $inoxico, 'references' => $references];

        Mail::send('emails.inoxico', $data, function($message)
        {
            //$message->to('Admin2@prestigeAdvantage.co.za', 'Admin2')->bcc('rachael@statusdata.co.za','Rachael')->cc('Admin1@prestigeAdvantage.co.za','Admin1')->subject('Prestige Enquiry');
            $message->to('sgilmore@statusdata.co.za','Stehpen')->to('rachael@statusdata.co.za','Rachael')->subject('Inoxico Researched Report');
            $message->from('Admin2@prestigeAdvantage.co.za');
        });

        return Redirect::to('/home')->with('view-success',' Your request has been successfully submitted.');
    }
}